#include <EEPROM.h>
#include <Wire.h>

const int MCP7940SLAVEADR=B1101111;
const int SEKUNDENADR=0;
const int KONTROLBITS=B01000001; // 4096Hz-Ausgabe an 
const int KONTROLRADR=7;

const byte SensorPin=A0;
const byte TastenPin=A1;
const byte PiezoPin=A2;
// A3 frei
// A4 = SDA
// A5 = SCL

const byte DecoderPins[3] = {11, 12, 13};
const byte DecoderPinsSize=sizeof(DecoderPins)/sizeof(DecoderPins[0]);

const byte SegmentePins[8] = {3, 4, 5, 6, 7, 8, 9, 10};
const byte SegmentePinsSize=sizeof(SegmentePins)/sizeof(SegmentePins[0]);

const int DcfPin=2; // Eingang für optionalen DCF-Empfänger

const byte Seg_A=0x01;
const byte Seg_B=0x02;
const byte Seg_C=0x04;
const byte Seg_D=0x08;
const byte Seg_E=0x10;
const byte Seg_F=0x20;
const byte Seg_G=0x40;
const byte Punkt=0x80;

const byte Ziffer_0=Seg_A+Seg_B+Seg_C+Seg_D+Seg_E+Seg_F;
const byte Ziffer_1=      Seg_B+Seg_C                  ;
const byte Ziffer_2=Seg_A+Seg_B      +Seg_D+Seg_E      +Seg_G;
const byte Ziffer_3=Seg_A+Seg_B+Seg_C+Seg_D            +Seg_G;
const byte Ziffer_4=      Seg_B+Seg_C            +Seg_F+Seg_G;
const byte Ziffer_5=Seg_A      +Seg_C+Seg_D      +Seg_F+Seg_G;
const byte Ziffer_6=Seg_A      +Seg_C+Seg_D+Seg_E+Seg_F+Seg_G;
const byte Ziffer_7=Seg_A+Seg_B+Seg_C                        ;
const byte Ziffer_8=Seg_A+Seg_B+Seg_C+Seg_D+Seg_E+Seg_F+Seg_G;
const byte Ziffer_9=Seg_A+Seg_B+Seg_C+Seg_D      +Seg_F+Seg_G;

const byte Buchstabe_A=Seg_A+Seg_B+Seg_C      +Seg_E+Seg_F+Seg_G;
const byte Buchstabe_E=Seg_A            +Seg_D+Seg_E+Seg_F+Seg_G;

const int GradZeichen=Seg_A+Seg_B                  +Seg_F+Seg_G;
const int CelsiusZeichen=Seg_A            +Seg_D+Seg_E+Seg_F      ;

const int Ziffern[10]={Ziffer_0, Ziffer_1, Ziffer_2, Ziffer_3, Ziffer_4, Ziffer_5, Ziffer_6, Ziffer_7, Ziffer_8, Ziffer_9};

const char Wochentage=7;
const char UhrzeitPunkte=0b011110;
const char DatumPunkte=0b010100;
const char WeckerPunkte=0b000110;

const byte JahrBlinkMuster=0x30;
const byte MonatBlinkMuster=0x0C;
const byte TagBlinkMuster=0x03;

const byte StundenBlinkMuster=0x03;
const byte MinutenBlinkMuster=0x0C;
const byte SekundenBlinkMuster=0x30;

const byte WeckerEinAusBlinkMuster=0x20;
const byte WeckerStundenBlinkMuster=0x03;
const byte WeckerMinutenBlinkMuster=0x0C;

const byte AuswahlTasteBit=0;
const byte PlusTasteBit=1;
const byte MinusTasteBit=2;

const int MaxModuszeit=500;
const int Blinkzeit=500;
const int MaxTastenCount=15;

const int MultiplexZeit=2500;

const int Wecker_Eeprom_Adr=0;
//------------------------------------------------------------------------------------------------------------------

int Anzeigen[6];

char Stunden, Minuten, Sekunden;
char Wtag, Tag, Monat, Jahr;
char Konfig, SpezBits;

char AltMinuten;

int Temperatur;

byte Blinken;
byte AktTasten, NeuTasten, AltTasten;
int TastenCount=0;

int Modus=0, SubModus=0;
int Moduszeit=0;

struct {
  bool EinAus;
  char Stunden, Minuten;
} Wecker;

bool WeckerSchellt;

bool DcfGestellt=false;

//------------------------------------------------------------------------------------------------------------------

byte Bcd2Bin(byte Bcd) {
  return Bcd-(Bcd/16)*6;
}

//------------------------------------------------------------------------------------------------------------------

byte Bin2Bcd(byte Bin) {
  return Bin+(Bin/10)*6;
}

//------------------------------------------------------------------------------------------------------------------

char RechneWochenTag(char Tag, char Monat, char Jahr) {
  Jahr=Jahr+((Monat+9)/12)-1;
  Monat=(Monat+9)%12;
  int AnzahlDerTage=Jahr+(Jahr/4)+Monat*30+((6*Monat+5)/10)+Tag+1;
  return (AnzahlDerTage%Wochentage)+1; // 1=Mo, 2=Di, ...
}

//------------------------------------------------------------------------------------------------------------------

void setup() {
  Serial.begin(9600);
  Wire.begin();
  Wire.beginTransmission(MCP7940SLAVEADR);
  Wire.write(KONTROLRADR);
  Wire.write(KONTROLBITS);
  Wire.endTransmission(); 
  
  pinMode(TastenPin, INPUT_PULLUP);
  pinMode(PiezoPin, OUTPUT);

  for (int i=0; i<DecoderPinsSize; i++)
  {
    pinMode(DecoderPins[i], OUTPUT);
    digitalWrite(DecoderPins[i], LOW);
  }
  for (int i=0; i<SegmentePinsSize; i++)
  {
    pinMode(SegmentePins[i], OUTPUT);
    digitalWrite(SegmentePins[i], LOW);
  }
  pinMode(DcfPin,INPUT_PULLUP);
  attachInterrupt(0,dcfAuswertung,CHANGE);

  LeseUhrzeitAusRTC();
  MesseTemperatur();
  WeckerSchellt=false;
  Modus=0; SubModus=0; Moduszeit=0;
  TastenCount=0;
  Serial.println(F("EGS Abschlusspruefung Teil 1, Herbst 2024"));
}

//------------------------------------------------------------------------------------------------------------------

void SetzeDecoder(int Decoder) {
  for (int i=0; i<3; i++)
     digitalWrite(DecoderPins[i], bitRead(Decoder, i));
}

//------------------------------------------------------------------------------------------------------------------

void SetzeSegmente(int Segmente) {
  for (int i=0; i<SegmentePinsSize; i++)
     digitalWrite(SegmentePins[i], bitRead(Segmente, i));
}

//------------------------------------------------------------------------------------------------------------------

void Multiplexen(int Plexi){
  while(Plexi) {
    byte HilfBlinken=Blinken;
    if (millis()%Blinkzeit<Blinkzeit/2) HilfBlinken=0;
    for (int Anzeige=0; Anzeige<6; Anzeige++) {
      SetzeDecoder(Anzeige);
      if (!bitRead(HilfBlinken, Anzeige)) SetzeSegmente(Anzeigen[Anzeige]); else SetzeSegmente(Anzeigen[Anzeige]&Punkt);
      delayMicroseconds(MultiplexZeit);
      SetzeSegmente(0);
      bitWrite(AktTasten, Anzeige, !digitalRead(TastenPin));
    }
    Plexi--;
  }
  TastenAuswertung();
}

//------------------------------------------------------------------------------------------------------------------

void LoescheAnzeige() {
  for (int i=0; i<6; i++)
    Anzeigen[i]=0;
}

//------------------------------------------------------------------------------------------------------------------

void SetzeZiffer(int Stelle, int Ziffer) {
  Anzeigen[Stelle]=Ziffern[Ziffer];
}

//------------------------------------------------------------------------------------------------------------------

void SetzeZahl(char Stelle, char Zahl) {
  char Zehner=Zahl/10;
  char Einer=Zahl%10;
  SetzeZiffer(Stelle, Zehner);
  SetzeZiffer(Stelle+1, Einer);
}

//------------------------------------------------------------------------------------------------------------------

void SetzeZahlOhneNull(char Stelle, char Zahl) {
  char Zehner=Zahl/10;
  char Einer=Zahl%10;
  if (Zehner>0) SetzeZiffer(Stelle, Zehner);
  SetzeZiffer(Stelle+1, Einer);
}

//------------------------------------------------------------------------------------------------------------------

void SetzePunkte(char Punkte) {
  for(int i=0; i<6; i++)
    if (bitRead(Punkte, i)) Anzeigen[i]=Anzeigen[i]|Punkt;
}

//------------------------------------------------------------------------------------------------------------------

void SetzeUhrzeitZurAnzeige() {
  LoescheAnzeige();
  SetzeZahl(0, Stunden);
  SetzeZahl(2, Minuten);
  SetzeZahl(4, Sekunden);
  SetzePunkte(UhrzeitPunkte);
}

//------------------------------------------------------------------------------------------------------------------

void SetzeDatumZurAnzeige() {
  LoescheAnzeige();
  SetzeZahl(0, Tag);
  SetzeZahl(2, Monat);
  SetzeZahl(4, Jahr);
  SetzePunkte(DatumPunkte);
}

//------------------------------------------------------------------------------------------------------------------

void SetzeTemperaturZurAnzeige() {
  LoescheAnzeige();
  int HilfsTemperatur=Temperatur;
  if (HilfsTemperatur<0) {
    Anzeigen[1]=Seg_G;
    HilfsTemperatur=-HilfsTemperatur;
  }
  SetzeZahlOhneNull(2, HilfsTemperatur);
  Anzeigen[4]=GradZeichen; // ° 
  Anzeigen[5]=CelsiusZeichen; // C
}

//------------------------------------------------------------------------------------------------------------------

void SetzeWeckerZurAnzeige() {
  LoescheAnzeige();
  SetzeZahl(0, Wecker.Stunden);
  SetzeZahl(2, Wecker.Minuten);
  if (Wecker.EinAus) Anzeigen[5]=Buchstabe_E; else Anzeigen[5]=Buchstabe_A;
  SetzePunkte(WeckerPunkte);
}

//------------------------------------------------------------------------------------------------------------------

void MesseTemperatur() {
  int U=analogRead(SensorPin);
  int T=map(U, 0, 1023, 0, 500);
  Temperatur=T-273;
}

//------------------------------------------------------------------------------------------------------------------

void loop() {
  AltMinuten=Minuten;
  if (DcfGestellt==true) { DcfGestellt=false; SchreibeUhrzeitInRTC(); }

  LeseUhrzeitAusRTC();
  LeseWeckerAusEeprom();
  if (AltMinuten!=Minuten) {
    if (Wecker.EinAus==true && Stunden==Wecker.Stunden && Minuten==Wecker.Minuten)  WeckerSchellt=true;  
  }
  if (Modus!=0) Moduszeit++; else Moduszeit=0;
  if (Moduszeit>MaxModuszeit) Modus=0;
  switch (Modus) {
    case 0: { 
      Blinken=0x00;
      if ( WeckerSchellt) { Blinken=0x3F; SubModus=0; }
      SubModus++;
      switch(SubModus) {
        case   1 ... 100: SetzeUhrzeitZurAnzeige();  break; 
        case 101 ... 200: SetzeDatumZurAnzeige();  break; 
        case 201 ... 300: SetzeUhrzeitZurAnzeige();  break; 
        case 301 ... 400: if (SubModus==301) MesseTemperatur(); SetzeTemperaturZurAnzeige(); break; 
        default: SubModus=0;
      }
      break;
    }
    case  1: { Blinken=WeckerEinAusBlinkMuster; SetzeWeckerZurAnzeige(); break; }
    case  2: { Blinken=WeckerStundenBlinkMuster; SetzeWeckerZurAnzeige(); break; }
    case  3: { Blinken=WeckerMinutenBlinkMuster; SetzeWeckerZurAnzeige(); break; }
    
    case  4: { Blinken=JahrBlinkMuster; SetzeDatumZurAnzeige(); break; }
    case  5: { Blinken=MonatBlinkMuster; SetzeDatumZurAnzeige(); break; }
    case  6: { Blinken=TagBlinkMuster; SetzeDatumZurAnzeige();  break; }
    
    case  7: { Blinken=StundenBlinkMuster; SetzeUhrzeitZurAnzeige(); break; }
    case  8: { Blinken=MinutenBlinkMuster; SetzeUhrzeitZurAnzeige(); break; }
    case  9: { Blinken=SekundenBlinkMuster; SetzeUhrzeitZurAnzeige(); break; }
  }
  digitalWrite(PiezoPin, WeckerSchellt);
  Multiplexen(2);
}

//------------------------------------------------------------------------------------------------------------------

void LeseUhrzeitAusRTC() {
  unsigned long t=millis();
  Wire.beginTransmission(MCP7940SLAVEADR);
  Wire.write(SEKUNDENADR);
  Wire.endTransmission(); 
  Wire.requestFrom(MCP7940SLAVEADR, 7);
  while (Wire.available()<7 && millis()-t<1);
  if (Wire.available()==7) // Sekunden, Minuten, Stunden, Tag, Wtag, Monat, Jahr
  {
    Sekunden=Bcd2Bin(Wire.read()&0x7F); // Start-/Stoppbit löschen
    Minuten=Bcd2Bin(Wire.read());
    Stunden=Bcd2Bin(Wire.read());
    Wtag=(Wire.read()&0x07);
    Tag=Bcd2Bin(Wire.read());
    Monat=Bcd2Bin(Wire.read()&0x1F); // Schaltjahr-Bit löschen
    Jahr=Bcd2Bin(Wire.read());
  }
}

//------------------------------------------------------------------------------------------------------------------

void SchreibeUhrzeitInRTC() {
  Wtag=RechneWochenTag(Tag, Monat, Jahr);
  Wire.beginTransmission(MCP7940SLAVEADR);
  Wire.write(SEKUNDENADR);
  Wire.write(Bin2Bcd(Sekunden)|0x80); // Oscillator starten
  Wire.write(Bin2Bcd(Minuten));
  Wire.write(Bin2Bcd(Stunden));
  Wire.write(Wtag);
  Wire.write(Bin2Bcd(Tag));
  Wire.write(Bin2Bcd(Monat));
  Wire.write(Bin2Bcd(Jahr));
  Wire.write(KONTROLBITS);
  Wire.endTransmission(); 
}

//------------------------------------------------------------------------------------------------------------------

void TastenAuswertung() {
  char MaxTage=31;
  if (Monat==4 || Monat==6 || Monat==9 || Monat==11) MaxTage=30;
  if (Monat==2) {
    MaxTage=28;
    if (Jahr%4==0) MaxTage=29;
  }
  if (NeuTasten==AktTasten) // Tasten entprellt
  {
    if (bitRead(AltTasten, AuswahlTasteBit)==LOW && bitRead(NeuTasten, AuswahlTasteBit)==HIGH) { // Auswahl-Taste betaetigt
      if (WeckerSchellt)
      {
         WeckerSchellt=false;
      } else {
        SubModus=0; 
        if (Modus==0) {
          if (bitRead(NeuTasten, PlusTasteBit)==HIGH || bitRead(NeuTasten, MinusTasteBit)==HIGH) Modus=4; else Modus=1;
        } else {
          Modus++; 
          if (Modus==4 || Modus==10) Modus=0;
//          if (Modus==2 && Wecker.EinAus==false) Modus=0;
          Moduszeit=0;
        }
      }
    }
    if (Modus>1 && (bitRead(NeuTasten, PlusTasteBit)==HIGH || bitRead(NeuTasten, MinusTasteBit)==HIGH)) TastenCount++; else TastenCount=0;
    if ((bitRead(AltTasten, PlusTasteBit)==LOW && bitRead(NeuTasten, PlusTasteBit)==HIGH) || (bitRead(NeuTasten, PlusTasteBit)==HIGH && TastenCount>MaxTastenCount)) { // Plustaste betätigt
      Moduszeit=0; TastenCount=0;
      switch(Modus) {
        case  1: Wecker.EinAus=!Wecker.EinAus; SchreibeWeckerInsEeprom(); break;
        case  2: Wecker.Stunden++; if(Wecker.Stunden>23) Wecker.Stunden=0; SchreibeWeckerInsEeprom(); break;
        case  3: Wecker.Minuten++; if(Wecker.Minuten>59) Wecker.Minuten=0; SchreibeWeckerInsEeprom(); break;

        case  4: Jahr++; if(Jahr>99) Jahr=0; SchreibeUhrzeitInRTC(); break;
        case  5: Monat++; if(Monat>12) Monat=1; SchreibeUhrzeitInRTC(); break;
        case  6: Tag++; if(Tag>MaxTage) Tag=1; SchreibeUhrzeitInRTC(); break;

        case  7: Stunden++; if(Stunden>23) Stunden=0; SchreibeUhrzeitInRTC(); break;
        case  8: Minuten++; if(Minuten>59) Minuten=0; SchreibeUhrzeitInRTC(); break;
        case  9: Sekunden++; if(Sekunden>59) Sekunden=0; SchreibeUhrzeitInRTC(); break;
      }
    }
    if ((bitRead(AltTasten, MinusTasteBit)==LOW && bitRead(NeuTasten, MinusTasteBit)==HIGH) || (bitRead(NeuTasten, MinusTasteBit)==HIGH && TastenCount>MaxTastenCount)) { // Minustaste betaetigt
      Moduszeit=0; TastenCount=0;
      switch(Modus) {
        case 1: Wecker.EinAus=!Wecker.EinAus;  SchreibeWeckerInsEeprom(); break;
        case 2: Wecker.Stunden--; if(Wecker.Stunden<0) Wecker.Stunden=23; SchreibeWeckerInsEeprom(); break;
        case 3: Wecker.Minuten--; if(Wecker.Minuten<0) Wecker.Minuten=59; SchreibeWeckerInsEeprom(); break;

        case 4: Jahr--; if(Jahr<0) Jahr=99; SchreibeUhrzeitInRTC(); break;
        case 5: Monat--; if(Monat<1) Monat=12; SchreibeUhrzeitInRTC(); break;
        case 6: Tag--; if(Tag<1) Tag=MaxTage; SchreibeUhrzeitInRTC(); break;

        case 7: Stunden--; if(Stunden<0) Stunden=23; SchreibeUhrzeitInRTC(); break;
        case 8: Minuten--; if(Minuten<0) Minuten=59; SchreibeUhrzeitInRTC(); break;
        case 9: Sekunden--; if(Sekunden<0) Sekunden=59; SchreibeUhrzeitInRTC(); break;
      }
    }
    AltTasten=NeuTasten;
  }
  NeuTasten=AktTasten;
}

//------------------------------------------------------------------------------------------------------------------

void SchreibeWeckerInsEeprom() {
  EEPROM.write(Wecker_Eeprom_Adr+0, Wecker.EinAus);
  EEPROM.write(Wecker_Eeprom_Adr+1, Wecker.Stunden);
  EEPROM.write(Wecker_Eeprom_Adr+2, Wecker.Minuten);
}

//------------------------------------------------------------------------------------------------------------------

void LeseWeckerAusEeprom() {
  Wecker.EinAus=EEPROM.read(Wecker_Eeprom_Adr+0);
  Wecker.Stunden=EEPROM.read(Wecker_Eeprom_Adr+1);
  Wecker.Minuten=EEPROM.read(Wecker_Eeprom_Adr+2);
  if (Wecker.Stunden<0 || Wecker.Stunden>23 || Wecker.Minuten<0 || Wecker.Minuten>59) {
    Wecker.EinAus=false; Wecker.Stunden=6; Wecker.Minuten=0;
  }
}

//------------------------------------------------------------------------------------------------------------------

void dcfAuswertung() {
  static byte DcfSpezBits, DcfMinuten, DcfStunden, DcfWtag, DcfTag, DcfMonat, DcfJahr;
  static byte DcfBitCount=0;
  static byte DcfBits;
  static byte DcfParitaet;
  static unsigned long t1;
  unsigned long t2;
  
  t2=t1; t1=millis(); t2=t1-t2;
  if (t2>750) { // Pause lange genug?
    if (t2>1750) { // lange Pause?
      if (t2<1850) DcfParitaet++;
      if ((DcfParitaet%2)==1) DcfBitCount=0;
      if (DcfBitCount==58) {
        SpezBits=DcfSpezBits; Stunden=Bcd2Bin(DcfStunden); Minuten=Bcd2Bin(DcfMinuten); Sekunden=0;
        Wtag=DcfWtag; Tag=Bcd2Bin(DcfTag); Monat=Bcd2Bin(DcfMonat); Jahr=Bcd2Bin(DcfJahr);
        DcfGestellt=true;
      }
      DcfBitCount=0;
    } else { // kurze Pause
      DcfBitCount++;
      DcfBits=DcfBits>>1;
      if (t2<850) { bitSet(DcfBits,7); DcfParitaet++; }
      
      switch (DcfBitCount) { // Bits auswerten
        case 1: break;
        case 15: break; 
        case 20: DcfSpezBits=(DcfBits>>3)&0x1F;
                 break; 
        case 21: DcfParitaet=0;
                 break; 
        case 29: DcfMinuten=DcfBits&0x7F;
                 if ((DcfParitaet%2)==1) DcfBitCount=0; 
                 break;
        case 36: DcfStunden=(DcfBits>>1)&0x3F;
                 if ((DcfParitaet%2)==1) DcfBitCount=0; 
                 break; 
        case 42: DcfTag=(DcfBits>>2)&0x3F;
                 break;
        case 45: DcfWtag=(DcfBits>>5)&0x07;
                 break; 
        case 50: DcfMonat=(DcfBits>>3)&0x1F;
                 break; 
        case 58: DcfJahr=DcfBits;
                 break; 
      }
    }
  } 
}

//------------------------------------------------------------------------------------------------------------------
 
