/* 
 */

#include <LiquidCrystal.h>

LiquidCrystal lcd(12, 11, 5, 4, 3, 2);
byte Ue[8] = {B01010, B00000, B10001, B10001, B10001, B10001, B01110};

boolean modus_auto=true;
int auto_zaehler=0;
int raum_nr=0;
boolean fehler_zuhoch=false, fehler_zuniedrig=false;
int temp_ist=0, temp_soll=0;
 
static String raum_name[] =
{
   "Vorraum         ", 
   "Reinraum        ",
   "Raum 3          ", 
   "Raum 4          ", 
   "Raum 5          ", 
   "Raum 6          ", 
   "Raum 7          ", 
   "Raum 8          ", 
};

static float temp10_volt[] =
{
   0.2026, 0.7122, 1.247, 1.739, 2.234, 2.704, 3.156, 3.583, 4
};
 
void setup()
{
   pinMode(6, OUTPUT);
   pinMode(7, OUTPUT);
   pinMode(8, OUTPUT);
   pinMode(9, OUTPUT);
   pinMode(10, OUTPUT);
   pinMode(13, INPUT);

   pinMode(A0, INPUT);
   pinMode(A1, INPUT);
   pinMode(A2, INPUT);
   pinMode(A3, INPUT);
   pinMode(A4, INPUT);
   pinMode(A5, INPUT);

   lcd.begin(16, 4);
   lcd.createChar(0, Ue);
   
   lcd.setCursor(3,0);
   lcd.print("Messstellen-");
   lcd.setCursor(3,1);
   lcd.write(byte(0));
   lcd.print("berwachung");
   lcd.setCursor(7,2);
   lcd.print("EGS");
   lcd.setCursor(0,4);
   lcd.print("Pr\365fung  So 2024");

   delay(4000);
 
   lcd.clear();
   lcd.setCursor(0,1);
   lcd.print("Ist         Soll");
   lcd.setCursor(0,2);
   lcd.print("xx\337C        yy\337C");

   zeigeRaum();
   zeigeTemperatur();
   zeigeFehler();
}


void zeigeRaum()
{
   lcd.setCursor(0,0);
   lcd.print(raum_name[raum_nr]);
   
   digitalWrite(10, raum_nr & 4);
   digitalWrite(9, raum_nr & 2);
   digitalWrite(8, raum_nr & 1);
}

void zeigeTemperatur()
{
   lcd.setCursor(0,2);
   if (temp_ist < 10)
      lcd.print(" ");
   lcd.print(temp_ist);

   lcd.setCursor(12,2);
   if (temp_soll < 10)
      lcd.print(" ");
   lcd.print(temp_soll);
}

void zeigeFehler()
{
   lcd.setCursor(0,3);
   if(fehler_zuhoch)
      lcd.print(" Temp zu hoch! ");
   else if(fehler_zuniedrig)
      lcd.print("Temp zu niedrig!");
   else
      lcd.print(" Temperatur ok. ");
   
}

int wandleVoltZuTemp(float volt)
{
   int temp=-1;
   
   if (volt < temp10_volt[0])
      temp = 0;
   else if (volt >= temp10_volt[8])
      temp = 80;
   else
   {
      for (int i=0; i<8; i++)
      {
	 if (volt < temp10_volt[i+1])
	 {
	    temp = i*10 + ( (volt - temp10_volt[i]) / ((temp10_volt[i+1] - temp10_volt[i]) / 10) );
	    break;
	 }
      }
   }
   
   return temp;
}


void loop()
{
   if(modus_auto)
   {
     if(++auto_zaehler > 15)
     {
	 auto_zaehler=0;
	 if(++raum_nr > 7)
	    raum_nr=0;

	 zeigeRaum();
     }
     
     if(digitalRead(A4) == LOW)
	 modus_auto=false;
   }
   else
   {
     if(digitalRead(A3) == LOW)
     {
	 modus_auto=true;
	 auto_zaehler=0;
     }
     else if(digitalRead(A5) == LOW)
     {
	 while(digitalRead(A5) == LOW)
	    delay(10);
   
	 if(++raum_nr > 7)
	    raum_nr=0;

	 zeigeRaum();
     }
   }
   
   fehler_zuhoch = !digitalRead(A2);
   fehler_zuniedrig = !digitalRead(13);
   digitalWrite(6, fehler_zuhoch);
   digitalWrite(7, fehler_zuniedrig);
   zeigeFehler();
   
   {
      int wert_ist = analogRead(A0);
      float volt_ist = ((float)wert_ist*5)/1024;
      temp_ist = wandleVoltZuTemp(volt_ist);
      
      int wert_soll = analogRead(A1);
      float volt_soll = ((float)wert_soll*5)/1024;
      temp_soll = wandleVoltZuTemp(volt_soll);
   }
   zeigeTemperatur();
   
   delay(100);
}
