#include <LiquidCrystal.h>

#define LED1_pin 2
#define LED2_pin 3
#define Relais_pin 4
#define Taster_hoch_pin 5
#define Taster_runter_pin 6
#define Taster_start_pin 7
#define Trigger_pin 8
#define Entlade_pin 9

volatile bool Flanke = 1;
volatile bool mess_ende = 0;
volatile bool ovl = 0;
volatile uint16_t t = 0;

float zeit = 0.0;
float c = 0.0;
uint8_t messber = 1;

//                rs, en, d4, d5, d6, d7
LiquidCrystal lcd(15, 14, 16, 17, 18, 19);

void init_input_capture()
{
  TCCR1A = 0;
  TCCR1B = 0;
  TIFR1 = (1 << ICF1) | (1 << OCF1B) | (1 << OCF1A) | (1 << TOV1);
  TIMSK1 =   (1 << ICIE1) | (1 << TOIE1);
  TCCR1B = ( (1 << ICES1) | (1 << ICNC1) );
  Flanke = 1;
}

void Relais(boolean stat)
{
  digitalWrite(Relais_pin, stat);
}

void led_rot(void)
{
  digitalWrite(LED2_pin, LOW);
  digitalWrite(LED1_pin, HIGH);
}


void led_gruen(void)
{
  digitalWrite(LED1_pin, LOW);
  digitalWrite(LED2_pin, HIGH);
}

void ZeigeMessbereich() {
  lcd.setCursor(0, 0);
  lcd.print("Messbereich: ");
  lcd.print(messber);
}

void Messung_start()
{
  lcd.setCursor(3, 1);
  lcd.print("             ");
  lcd.setCursor(3, 1);

  switch (messber)
  {
    case 1: Relais(0);
      TCCR1B = ( (1 << ICES1) | (1 << ICNC1) | (1 << CS11));
      break;

    case 2: Relais(0);
      TCCR1B = ( (1 << ICES1) | (1 << ICNC1) | (1 << CS11) | (1 << CS10));
      break;

    case 3: Relais(1);
      TCCR1B = ( (1 << ICES1) | (1 << ICNC1) | (1 << CS11) | (1 << CS10));
      break;
  }
  digitalWrite(Entlade_pin, HIGH);
  delay(100);      //Entladezeit
  digitalWrite(Entlade_pin, LOW);

  ovl = 0;
  TCNT1 = 0;
  Flanke = 1;

  TCCR1B |=  (1 << ICES1); 
}


void setup() {
  Serial.begin(9600);
  Serial.println("EGS-Pruefung Teil 1, Fruehjahr 2024");

  pinMode(Entlade_pin, OUTPUT);
  digitalWrite(Entlade_pin, HIGH);

  pinMode(Relais_pin, OUTPUT);
  digitalWrite(Relais_pin, LOW);

  pinMode(Trigger_pin, INPUT);
  pinMode(Taster_hoch_pin, INPUT);
  pinMode(Taster_runter_pin, INPUT);
  pinMode(Taster_start_pin, INPUT);

  pinMode(LED1_pin, OUTPUT);
  digitalWrite(LED1_pin, LOW);
  pinMode(LED2_pin, OUTPUT);
  digitalWrite(LED2_pin, HIGH);

  lcd.begin(16, 2);
  lcd.print("EGS-Pruef Teil 1");

  init_input_capture();

  delay(1000);
  lcd.clear();
  ZeigeMessbereich();
  lcd.setCursor(0, 1);
  lcd.print("C= ");
}

void loop() {
  if (!digitalRead(Taster_hoch_pin))
  {
    if (messber < 3) messber++; else messber = 3;
    ZeigeMessbereich();
    delay(600);
  }

  if (!digitalRead(Taster_runter_pin))
  {
    if (messber > 1)messber--; else messber = 1;
    ZeigeMessbereich();
    delay(600);
  }

  if (!digitalRead(Taster_start_pin))
  {
    led_rot();
    Messung_start();
    delay(100);
    led_gruen();
  }

  if (ovl)
  {
    TCCR1B = 0; 
    Flanke = 1;
    mess_ende = 1;
  }

  if (mess_ende == 1)
  {
    delay(100);
    Relais(0);
    digitalWrite(Entlade_pin, HIGH);

    lcd.setCursor(3, 1);
    lcd.print("             ");
    lcd.setCursor(3, 1);

    if (ovl)
    {
      lcd.print("**OVL**");
    }
    else
    {
      zeit = t;
      if (messber == 1)
      {
        zeit /= 2;
        c = (250 * zeit) / 2; // I=250µA, U=2V
        lcd.print(c, 0);
        lcd.print(" pF  ");
      }

      if (messber == 2)
      {
        zeit *= 4;
        c = (0.25 * zeit) / 2; // I=250µA, U=2V
        lcd.print(c, 1);
        lcd.print(" nF  ");
      }

      if (messber == 3)
      {
        zeit *= 4;
        c = (0.02 * zeit) / 2; // I=20mA, U=2V
        lcd.print(c, 1);
        lcd.print(" \xE4""F  ");
      }
    }
    mess_ende = 0;
  }
}

ISR(TIMER1_OVF_vect) {
  ovl = 1;
}

ISR(TIMER1_CAPT_vect)
{
  if (Flanke == 1)
  {
    TCNT1 = 0;
    TCCR1B &=  ~(1 << ICES1);
    Flanke = 0;
  } else {
    t = ICR1;
    TCCR1B = 0;
    Flanke = 1;
    mess_ende = 1;
  }
}

