#include <stdio.h>
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>
#include <pu2clr_pcf8574.h>
#include <SPI.h>

LiquidCrystal_I2C lcd(0x20,16,4);  // set the LCD address to 0x27 for a 16 chars and 2 line display(for PCF8574A 0x38)

PCF pcf;

/************** Definitionen ****************************/

#define A 3          
#define B 4
#define C 5
#define LEDc 2
#define Taster1 6
#define Taster2 7
#define Taster3 8
#define _7SEGc1 1
#define _7SEGc2 0
#define MultiOUT A0
#define LS1 A1
#define LS2 A2



/**************GLOBALE VARIABLEN*************************/
const int slaveSelectPin = 10;
int brightness = 50;
int brightness_last = 50;
int LED = 0;
int FZG = 0;
int FZG_last = 0;
int Tastercnt = 3;
byte address = 0x00;
byte Inputs = 0x00;
byte LEDcount = 0;
byte LEDcount_last = 0;
bool Pmod = 0;
bool Taster1_last = LOW;
bool Taster2_last = LOW;
bool Taster3_last = LOW;
bool LS1_last = LOW;
bool LS2_last = LOW;

int LEDval[8];

unsigned int reload = 0xF424;

// Feld für 7Seg-CA   
const char segmente[] = 
  // abcdefg 
    {0b11000000, // 0
     0b11111001, // 1
     0b10100100, // 2
     0b10110000, // 3
     0b10011001, // 4
     0b10010010, // 5
     0b10000010, // 6
     0b11111000, // 7
     0b10000000, // 8
     0b10010000}; // 9

/*
// Feld für 7Seg-CC   
const char segmente[] = 
  // abcdefg
    {0b00111111, // 0
     0b00110000, // 1
     0b01101101, // 2
     0b01111001, // 3
     0b01110010, // 4
     0b01011011, // 5
     0b01011111, // 6
     0b00000111, // 7
     0b01111111, // 8
     0b01111011}; // 9
*/
/*****************************************************
 ****************   SETUP   **************************
 ****************************************************/
 void setup()
{
  Serial.begin (9600);
  Serial.println ("EGS Winter 2023");
  Serial.end();
  
  lcd.init();                      // initialize the lcd 1
  lcd.backlight();
  lcd.clear();

  SPI.begin(); 
  
// Set the i2c HEX address
  uint8_t i2cAddr = 0x21; //Adresse für PCF8574A: 0x39;  für PCF8574: 0x21;
  pcf.setup(i2cAddr); // Starts the device with the found I2C address

  pinMode(LEDc,OUTPUT);
  pinMode(C,OUTPUT);
  pinMode(B,OUTPUT);
  pinMode(A,OUTPUT);
  pinMode(_7SEGc1,OUTPUT);
  pinMode(_7SEGc2,OUTPUT);
  pinMode(slaveSelectPin, OUTPUT);

  pinMode(Taster1,INPUT_PULLUP);
  pinMode(Taster2,INPUT_PULLUP);
  pinMode(Taster3,INPUT_PULLUP);
  pinMode(MultiOUT,INPUT);
  pinMode(LS1,INPUT);
  pinMode(LS2,INPUT);
 
  lcd.setCursor(0,1);
  lcd.print("EGS Winter 2023");
  delay(2000);
  lcd.clear();

  digitalPotWrite(128);   //LEDs zum Start auf mittlere Helligkeit


/**************  INTERRUPTS   *******************/

  cli();//stop interrupts
    //set timer1 interrupt at 1Hz
  TCCR1A = 0;// set entire TCCR1A register to 0
  TCCR1B = 0;// same for TCCR1B
  TCNT1  = 0;//initialize counter value to 0
  // set compare match register for 1hz increments
  OCR1A = 15624;// = (16*10^6) / (1*1024) - 1 (must be <65536)
  // turn on CTC mode
  TCCR1B |= (1 << WGM12);
  // Set CS12 and CS10 bits for 1024 prescaler
  TCCR1B |= (1 << CS12) | (1 << CS10);  
  // enable timer compare interrupt
  TIMSK1 |= (1 << OCIE1A);
  sei();//allow interrupts
}

/*
cli();
TCCR1A = 0;
TCCR1B = 0; 
OCR1A = reload;
TCCR1B = (1<<WGM12) | (1<<CS12); 
TIMSK1 = (1<<OCIE1A); 
sei(); 
}

*/
/**************** Interrupt fuer 1-Sekunde   **********/
ISR(TIMER1_COMPA_vect)
{
  if(!digitalRead(Taster1) && !digitalRead(Taster2) && !digitalRead(Taster3))
  {
    Tastercnt--;
    if(Tastercnt <= 0)
    {
      Pmod = !Pmod;
      Tastercnt = 3;
    }
  }
  else
  {
    Tastercnt = 3;
  }
  LEDcount++;
  
  if(LEDcount>7)
  {
    LEDcount=0;
  }
}

/****************  LCD ***********************/
void LCD_OUT()
{
  lcd.setCursor(0,0);
  lcd.print("HELLIGKEIT");
  if((brightness_last == 100) && (brightness<100))
  {
    lcd.setCursor(11,0);
    lcd.print(" ");
  }
  if((brightness_last > 0) && (brightness == 0))
  {
    lcd.setCursor(12,0);
    lcd.print(" ");
  }
  if(brightness == 100)
  {
    lcd.setCursor(11,0);
  }
  else if((brightness < 100) && (brightness > 0))
  {
    lcd.setCursor(12,0);
  }
  else
  {
    lcd.setCursor(13,0);
  }
  lcd.print(brightness);
  lcd.setCursor(14,0);
  lcd.print("\45");
  
  if(Pmod==0)
  {
    lcd.setCursor(0,1);
    lcd.print("MANUELL  +S2 -S3");
  }
  else
  {
    lcd.setCursor(0,1);
    lcd.print("     SENSOR     ");
  }
  lcd.setCursor(-2,2);
  lcd.print("LED ");
  lcd.setCursor(2,2);
  lcd.print(LEDcount);
  lcd.setCursor(4,2);
  if((LEDval[LEDcount]>=500) & (LEDval[LEDcount]<=2000))
  {
    lcd.print("FUNKTION");
  }
  else
  {
    lcd.print("STOERUNG");  
  }
  lcd.setCursor(-4,3);
  lcd.print("FAHRZEUGE");
  lcd.setCursor(10,3);
  lcd.print(FZG);
}

/********************   Inputs    ******************************/

void Inputabfrage()
{
  Inputs=0;
  if((digitalRead(Taster1) == LOW) && (Taster1_last == LOW))
  {
    Inputs |= B00000001;
    Taster1_last = HIGH;
  }
  else if(digitalRead(Taster1) == HIGH)
  {
    Taster1_last = LOW;
  }
  if((digitalRead(Taster2) == LOW) && (Taster2_last == LOW))
  {
    Inputs |= B00000010;
    Taster2_last = HIGH;
  }
  else if(digitalRead(Taster2) == HIGH)
  {
    Taster2_last = LOW;
  }
  if((digitalRead(Taster3) == LOW) && (Taster3_last == LOW))
  {
    Inputs |= B00000100;
    Taster3_last = HIGH;
  }
  else if(digitalRead(Taster3) == HIGH)
  {
    Taster3_last = LOW;
  }
  if((digitalRead(LS1) == HIGH) && (LS1_last == LOW))
  {
    Inputs |= B00001000;
    LS1_last = HIGH;
  }
  else if(digitalRead(LS1) == LOW)
  {
    LS1_last = LOW;
  }
  if(Pmod == HIGH)
  {
    if((digitalRead(LS2) == HIGH) && (LS2_last == LOW))
    {
      Inputs |= B00010000;
      LS2_last = HIGH;
    }
    else if(digitalRead(LS2) == LOW)
    {
      LS2_last = LOW;
    }
  }
}

/***************************  LED Abfrage   **************************/

void LEDabfrage()
{
  PORTD = PORTD & 0b11000111;
  PORTD = PORTD | (LEDcount<<3);
  LEDval[LEDcount] = (LEDval[LEDcount] + map(analogRead(MultiOUT),0,1023,0,5000))/2;
}

/* *****************************     SPI POTI    *********************/

void digitalPotWrite(int value)
 {
  // take the SS pin low to select the chip:
  digitalWrite(slaveSelectPin, LOW);
  // send in the address and value via SPI:
  SPI.transfer(address);
  SPI.transfer(value);
  // take the SS pin high to de-select the chip:
  digitalWrite(slaveSelectPin, HIGH);
}

/****************************************************************************/

/*********************** HELLIGKEIT      *****************************/
void Helligkeit()
{
  if(bitRead(Inputs,1))
  {
    brightness = brightness + 10;
    if(brightness > 100) brightness = 100;
  }
  if(bitRead(Inputs,2))
  {
    brightness = brightness - 10;
    if(brightness < 0) brightness = 0;
  }
  digitalPotWrite(map(brightness,0,100,0,255)); 
}

/************************* FAHRZEUGE       ****************************/

void Fahrzeuge()
{
  if(bitRead(Inputs,3))
  {
    FZG++;
    if(FZG > 99) FZG = 99;
  }
  if(bitRead(Inputs,4))
  {
    if(FZG>9)
    {
      lcd.clear();
    }
    FZG--;
    if(FZG < 0) FZG = 0;
  }
  if(bitRead(Inputs,0))
  {
    if(FZG>9)
    {
      lcd.clear();
    }
    FZG = 0;
  }
  if(FZG>14)
  {
    digitalWrite(LEDc,HIGH);
  }
  else if(FZG<10)
  {
    digitalWrite(LEDc,LOW);
  }
}

/******************  7-Segment Ausgabe     **************/
void _7SEGout()
{
  pcf.write(segmente[FZG/10]);
  digitalWrite(_7SEGc1,HIGH);
  delay(5);
  digitalWrite(_7SEGc1,LOW);
  pcf.write(segmente[FZG%10]);
  digitalWrite(_7SEGc2,HIGH);
  delay(5);
  digitalWrite(_7SEGc2,LOW);
}

void loop()
{
  Inputabfrage();
  Helligkeit();
  LEDabfrage();
  Fahrzeuge();
  _7SEGout();
  if((brightness_last != brightness) || (LEDcount_last != LEDcount) || (FZG_last != FZG))
  {
    LCD_OUT();
    LEDcount_last = LEDcount;
    FZG_last = FZG;
    brightness_last = brightness;
  }  
}
