// Projekt Drucksensor

//================================================================
// Konstanten

// Eingangspins für die Komparatoren
const int KOMPARATOR_1_PIN = A1;
const int KOMPARATOR_2_PIN = A2;
const int KOMPARATOR_3_PIN = A3;

// Ausgangspin für die Summer-Freigabe
const int SUMMER_PIN = 3;

// Ausgangspins für die Relais
const int RELAIS_1_PIN = 4;
const int RELAIS_2_PIN = 5;
const int RELAIS_3_PIN = 6;

// Ausgangspins für die LCD-Anzeige
const int LCD_E = 7;
const int LCD_RS = 8;
const int LCD_D4 = 9;
const int LCD_D5 = 10;
const int LCD_D6 = 11;
const int LCD_D7 = 12;

// Eingangspins für die TASTEN
const int TASTE_1_PIN = 2;
const int TASTE_2_PIN = 1;
const int TASTE_3_PIN = 0;

// Zeichen für die Balkenanzeige
const char BLOCK = '#';

//Konstanten zur Messbereichsanpassung
const int OFFSET = 25;
const int DIVISOR = 61;
const int ZYKLUSZEIT = 200;

//================================================================
// Variablen
bool Taste;
bool Taste_1;
bool Taste_2;
bool Taste_3;

bool Komparator_1;
bool Komparator_2;
bool Komparator_3;

bool Relais_1;
bool Relais_2;
bool Relais_3;

bool Summer;

int Druck;

//================================================================

#include <LiquidCrystal.h>

LiquidCrystal Lcd(LCD_RS, LCD_E, LCD_D4, LCD_D5, LCD_D6, LCD_D7);

//================================================================

void setup() {
  Lcd.begin(16, 4);
  Lcd.clear();
  Lcd.home();

  Serial.begin(9600);
  Serial.println("EGS Abschlusspruefung Teil 2, Winter 22/23");

  pinMode(TASTE_1_PIN, INPUT_PULLUP);
  pinMode(TASTE_2_PIN, INPUT_PULLUP);
  pinMode(TASTE_3_PIN, INPUT_PULLUP);

  pinMode(KOMPARATOR_1_PIN, INPUT_PULLUP);
  pinMode(KOMPARATOR_2_PIN, INPUT_PULLUP);
  pinMode(KOMPARATOR_3_PIN, INPUT_PULLUP);

  pinMode(RELAIS_1_PIN, OUTPUT);
  pinMode(RELAIS_2_PIN, OUTPUT);
  pinMode(RELAIS_3_PIN, OUTPUT);

  pinMode(SUMMER_PIN, OUTPUT);
}

//================================================================

void loop() {
  Eingabe();
  Verarbeitung();
  Ausgabe();
  delay(ZYKLUSZEIT);
}

//================================================================

void Eingabe() {
  Taste_1 = !digitalRead(TASTE_1_PIN); // L-aktiv
  Taste_2 = !digitalRead(TASTE_2_PIN);
  Taste_3 = !digitalRead(TASTE_3_PIN);

  Komparator_1 = !digitalRead(KOMPARATOR_1_PIN); // L-aktiv
  Komparator_2 = !digitalRead(KOMPARATOR_2_PIN);
  Komparator_3 = !digitalRead(KOMPARATOR_3_PIN);
}

//================================================================

void Verarbeitung() {
  Taste = Taste_1 || Taste_2 || Taste_3;

  Druck = analogRead(A0);
  Druck = Druck - OFFSET;
  if (Druck < 0) Druck = 0;
  Druck = Druck / DIVISOR;

  Relais_3 = Taste_3;
  Relais_2 = Taste_2 && !Relais_3;
  Relais_1 = Taste_1 && !Relais_2 && !Relais_3;

  if (Taste) Summer = 0; else Summer = Komparator_3;
}

//================================================================

void Ausgabe() {
  Lcd.clear();
  Lcd.home();
  if (Taste) {
    AusgabeEinstellung();
  } else {
    AusgabePruefung();
  }

  digitalWrite(RELAIS_1_PIN, Relais_1); // L-aktiv
  digitalWrite(RELAIS_2_PIN, Relais_2);
  digitalWrite(RELAIS_3_PIN, Relais_3);

  digitalWrite(SUMMER_PIN, Summer);
}

//================================================================

void AusgabeDruck() {
  Lcd.setCursor(6, 1);
  Lcd.print(0.125 * Druck, 1 ); Lcd.print(" N");
}

//================================================================

void AusgabeBalken() {
  Lcd.setCursor(0, 2);
  int Bloecke = constrain(Druck, 0, 16);
  for (int i = 0; i < Bloecke; i++)
    Lcd.print(BLOCK);
}

//================================================================

void AusgabeEinstellung() {
  Lcd.setCursor(0, 0);
  if (Taste_3) {
    Lcd.print("S3");
  } else if (Taste_2) {
    Lcd.print("S2");
  } else {
    Lcd.print("S1");
  }
  Lcd.print(" - Einstellung");

  AusgabeDruck();
  AusgabeBalken();

  Lcd.setCursor(1, 4);
  if (Taste_3) {
    Lcd.print("obere Grenze");
  } else if (Taste_2) {
    Lcd.print("mittlere Grenze");
  } else if (Taste_1) {
    Lcd.print("untere Grenze");
  }
}

//================================================================

void AusgabePruefung() {
  Lcd.setCursor(0, 0);
  Lcd.print("Werkstoffpr""\xF5""fung"); // \xF5 = ü

  AusgabeDruck();
  AusgabeBalken();

  Lcd.setCursor(1, 4);
  if (Komparator_3) {
    Lcd.print("obere Grenze");
  } else if (Komparator_2) {
    Lcd.print("mittlere Grenze");
  } else if (Komparator_1) {
    Lcd.print("untere Grenze");
  }
}

//================================================================
