#include <stdio.h>
#include <Wire.h> 
#include <LiquidCrystal_I2C.h>

#define Echo_EingangsPin 11 // Echo Eingangs-Pin
#define Trigger_AusgangsPin 4 // Trigger Ausgangs-Pin
#define LS_In 2
#define AnalogOUT 6
#define Taster1 8
#define Taster2 9
#define Taster3 3
#define HoehenTasterPin 7
#define PWM_OUT 5
#define LL_OUT 10
#define HeizPin A0
#define countTime 15

#define expander 0x39       // Adresse des PCF8574A mit allen 3 Adress-Pins nach +5V, B00100111 waere fuer den PCF8574 (siehe Datenblatt)
#define LM75A_01 0x4B       // Basisadresse fuer ersten Temperatursensor

// Registerparameter fuer get_LM75_temperature
#define TEMP 0            // Temperaturregister anwählen
#define UNTEN 2           // Register fuer den unteren Schaltwert anwählen
#define OBEN 3            // Register fuer den oberen Schaltwert anwählen

//Temperaturgrenzen LM75A
#define Wert_OBEN 32.0
#define Wert_UNTEN 29.0

//Ultraschallsensor
#define maximumRange 300
#define minimumRange 2

//LED Ampel-Muster
//Ampel 1 (P0-P2)
#define rot1 B00000001
#define gelb1 B00000010
#define gruen1 B00000100

//Ampel 2 (P3-P5)
#define rot2 B00001000
#define gelb2 B00010000
#define gruen2 B00100000

LiquidCrystal_I2C lcd1(0x20,16,2);  // set the LCD address to 0x27 for a 16 chars and 2 line display(for PCF8574A 0x38)
LiquidCrystal_I2C lcd2(0x21,16,2);  // set the LCD address to 0x28 for a 16 chars and 2 line display(for PCF8574A 0x39)
LiquidCrystal_I2C lcd3(0x38,16,4);  // set the LCD address to 0x28 for a 16 chars and 2 line display(for PCF8574A 0x40)


/**************GLOBALE VARIABLEN*************************/
char dataString[6];                       // gelesene Temperatur als String aufbereitet: (-xx)x.x
double temp;                              // gelesene Temperatur als double
bool tempDIR = HIGH;
//Ultraschallsensor
long Abstand;
long Dauer;
int ledpin=13;
int alle_x_sekunden=30;

bool Error1 = 0;
bool Error1_ends = HIGH;
bool Error1_last = LOW;
bool Error2 = 0;
bool Error2_ends = HIGH;
bool Error2_last = LOW;
bool Error3 = LOW;
bool Error3EN = LOW;
byte count_s2 = 0;
byte count_s1 = 0;
int Tastercnt = 3;

unsigned long previousMillis = 0;         // Variable für Zeitberechung mit millis() 
unsigned long previousMillis10s = 0;      // Variable für Zeitberechung mit millis() 10 Sekunden
unsigned long currentMillis =  0;
unsigned long currentMillis10s =  0;
unsigned long previousMillis5s = 0;      // Variable für Zeitberechung mit millis() 5 Sekunden
unsigned long currentMillis5s =  0;
const long interval_gruen = 5000;         // Wartezeit bei grün, bevor wieder auf gelb geschaltet wird (5 Sekunden)
const long interval_wechsel = 1000;       // Wartezeit bei Einspurverkehr, bevor weiter geschaltet wird (1 Sekunde)
const long interval_10s = 10000;          // Wartezeit 10 Sekunden
int ampel_case = 1;                       // Variabel zum Speichern des aktuellen Zustands der Ampeln



/*****************************************************
 ****************   SETUP   **************************
 ****************************************************/
 void setup()
{
  lcd1.init();                      // initialize the lcd 1
  lcd1.backlight();
  lcd2.init();                      // initialize the lcd 2
  lcd2.backlight();
  lcd3.init();                      // initialize the lcd 2
  lcd3.backlight();
  lcd3.setBacklight(LOW);
  
  pinMode(Trigger_AusgangsPin, OUTPUT);
  pinMode(Echo_EingangsPin, INPUT);
  pinMode(AnalogOUT,OUTPUT);
  pinMode(LS_In,INPUT);
  pinMode(Taster1,INPUT_PULLUP);
  pinMode(Taster2,INPUT_PULLUP);
  pinMode(Taster3,INPUT_PULLUP);
  pinMode(HoehenTasterPin,INPUT_PULLUP);
  pinMode(PWM_OUT,OUTPUT);
  pinMode(LL_OUT, OUTPUT);
  pinMode(HeizPin, OUTPUT);
  
  Serial.begin (9600);
  Serial.println ("EGS-Pruefung W21-22");
  Serial.end();
  
  lcd1.clear();
  lcd2.clear();
  lcd3.clear();

  // LM75 Schaltwerte setzen: Device, Register, Wert als double 
  set_LM75_schaltwert(UNTEN, Wert_UNTEN);
  set_LM75_schaltwert(OBEN, Wert_OBEN);

  attachInterrupt(digitalPinToInterrupt(Taster3), ErrorOFF, FALLING);

  cli();//stop interrupts
  
  //set timer1 interrupt at 1Hz
  TCCR1A = 0;// set entire TCCR1A register to 0
  TCCR1B = 0;// same for TCCR1B
  TCNT1  = 0;//initialize counter value to 0
  // set compare match register for 1hz increments
  OCR1A = 15624;// = (16*10^6) / (1*1024) - 1 (must be <65536)
  // turn on CTC mode
  TCCR1B |= (1 << WGM12);
  // Set CS12 and CS10 bits for 1024 prescaler
  TCCR1B |= (1 << CS12) | (1 << CS10);  
  // enable timer compare interrupt
  TIMSK1 |= (1 << OCIE1A);

  sei();//allow interrupts
}

/****************  PCF8574   ************************/
//Daten auf PCF8574A schreiben
void DataWrite(byte data)
{
  data = ~data;                                 //Daten einmal negieren, da LED mit invertierter Logik eingeschaltet werden  
  Wire.beginTransmission(expander);             //Öffnen der Verbindung
  Wire.write(data);                             //Schreiben des Bytes. Jede Null stellt ein Bit an den Pins des PCF8574 dar (Auch möglich in Hex Schreibweise)
  Wire.endTransmission();                       //Schließen der Verbindung
}

/**************** Interrupt für 1-Sekunde   **********/
ISR(TIMER1_COMPA_vect)
{
  
  if(Error1)
  {
    if(Error1_last == LOW)
    {
      count_s1 = countTime;
      Error1_last = HIGH;
    }
  }
  else
  {
    if(Error1_last == HIGH)
    {
      count_s1--;
      if(count_s1 <= 0)
      {
        Error1_last = LOW;
      }
    }
  }
  if(Error2)
  {
    if(Error2_last == LOW)
    {
      count_s2 = countTime;
      Error2_last = HIGH;
    }
  }
  else if(Error2_last == HIGH)
  {
    count_s2--;
    if(count_s2 == 0)
    {
      Error2_last = LOW;
    }
  }
  if(!digitalRead(Taster1) && !digitalRead(Taster2))
  {
    Tastercnt--;
    if(Tastercnt <= 0)
    {
      Error3EN = !Error3EN;
      Tastercnt = 3;
    }
  }

}

/****************  LM75  ***************************/
// LM75 Temperatur auslesen. Device = 0-7, regx = TEMP, OBEN, UNTEN (Registerauswahl)  
double get_LM75_temperature(int regx) 
{
  int8_t msb;
  int8_t lsb;
  int8_t msb1;
  Wire.beginTransmission(LM75A_01);   // Verbindung zum entsprechenden Temp-Sensor
  Wire.write(regx);                            // Gewünschtes Register vom Temp-Sensor ansprechen
  Wire.endTransmission();
  Wire.beginTransmission(LM75A_01);
  Wire.requestFrom(LM75A_01, 2);
  if (Wire.available()) {
     msb1 = Wire.read();                      // Aktuellen Temperaturwert auslesen
     msb = msb1 << 1;                         // Vorzeichenbit entfernen, verbliebener Wert ist nun doppelt so groß
     lsb = Wire.read();                       // Temp.-Wert nochmal einlesen für spätere Berechnung
  }
  // höchstes bit von lsb sagt aus, ob 0,5 Grad dazu addiert werden sollen
  lsb = (lsb & 0x80 ) >> 7;                   // nun ist lsb = 0 oder 1
  Wire.endTransmission();
  if (msb1 < 0x80) {                          // Positiver Wert?
    return double(msb + lsb)/2;               // positiver Wert
  }  
  else {
    return double(msb + lsb)/2 - 128;         // negativer Wert
  }  
}

// LM75 Konfigurationsregister setzen, Werte wie oben definiert
void set_LM75_config(byte value) 
{
  Wire.beginTransmission(LM75A_01);
  Wire.write(1);                                // Konfigurationsregister auswählen
  Wire.write(value);                            
  Wire.endTransmission();
}

// LM75 Konfigurationsregister auslesen, device = 0-7
byte get_LM75_config() 
{
  byte reg;
  Wire.beginTransmission(LM75A_01);
  Wire.write(1);                                // Konfigurationsregister auswählen
  Wire.endTransmission();
  Wire.requestFrom(LM75A_01, 1);
  if (Wire.available()) { 
     reg = Wire.read();
  }
  Wire.endTransmission();
  return reg;
} 

// LM75 Schaltwerte setzen, device = 0-7, regx = Wert, Grad als double
//gleiches Vorgehen, wie beim Auslesen der Temperaturwerte, nur, dass hier geschrieben wird
void set_LM75_schaltwert(byte regx, double grad) 
{
  int8_t msb;
  int8_t lsb = 0;
  uint8_t y = 0;
  boolean neg = false;
  if (grad < 0) {
    msb = abs(int(grad))+128;
  }
  else {  
    msb = abs(int(grad));
  }
  if (grad - abs(int(grad)) > 0) {
    lsb = 0x80;
  }
  Wire.beginTransmission(LM75A_01);
  Wire.write(regx);                                   // Selektiere oberes oder unteres Register
  Wire.write(msb);
  Wire.write(lsb);
  Wire.endTransmission();
}

// Temperatur Sensor einlesen und auf LCD ausgeben
void readTemp()
{
  // Temperatur von LM75 auslesen
  temp = get_LM75_temperature(TEMP);                 //(Device)Wert vom 1. Temperatursensor lesen (0-7, je nach Jumperstellung am Board, 2. Parameter wie oben definiert)
  dtostrf(temp, 4, 1, dataString);                  //dtostrf(floatVar, minStringWidthIncDecimalPoint, numVarsAfterDecimal, charBuf); standard avr-libc function ; damit Tempwert auf eine Nachkommastelle abgeschnitten wird
  if(temp>Wert_OBEN) tempDIR = LOW;
  if(temp<Wert_UNTEN) tempDIR = HIGH;
}

void analogOUT(int abstand)
{
  if(abstand > 20) abstand = 20;
  if(abstand < 4) abstand = 4;
  analogWrite(AnalogOUT, map(abstand,4,20,255,0));
  return;
}

void Abstand_Mess()
{
  // Abstandsmessung wird mittels des 10us langen Triggersignals gestartet
  digitalWrite(Trigger_AusgangsPin, HIGH);
  delayMicroseconds(10); 
  digitalWrite(Trigger_AusgangsPin, LOW);
  
  // Nun wird am Echo-Eingang gewartet, bis das Signal aktiviert wurde
  // und danach die Zeit gemessen, wie lang es aktiviert bleibt 
  Dauer = pulseIn(Echo_EingangsPin, HIGH);
  
  // Nun wird der Abstand mittels der aufgenommenen Zeit berechnet
  Abstand = Dauer/58.2;
  // Pause zwischen den einzelnen Messungen  
  delay(500);
  if(Abstand<=5) Error1 = HIGH;
  else  Error1 = LOW;
}

void LCD_OUT()
{
  //LCD 1 - 2-Zeilig Ultraschall-Warnung
  if(Error1_last)
  {
    lcd1.setBacklight(LOW);
  }
  else
  {
    lcd1.setBacklight(HIGH);
  }
  lcd1.setCursor(0,0);
  lcd1.print("H\357he 3m max");
  lcd1.setCursor(0,1);
  lcd1.print("Fahrzeug zu hoch");


  //LCD 2 - 2-Zeilig Kontakt-Warnung
  if(Error2_last)
  {
    lcd2.setBacklight(LOW);
  }
  else
  {
    lcd2.setBacklight(HIGH);
  }
  lcd2.setCursor(0,0);
  lcd2.print("ACHTUNG 300m");
  lcd2.setCursor(0,1);
  lcd2.print("Abfahrt nehmen");
  

  //LCD 3 - 4-Zeilig Info-LCD
  //lcd3.clear();
  lcd3.setCursor(0,0);
  lcd3.print("Tunnel Kontrolle");
  lcd3.setCursor(0,1);
  lcd3.print("Temperatur ");
  readTemp();
  lcd3.print(dataString);
  lcd3.print("C");
  lcd3.setCursor(-4,2);
  if(Error3EN)
  {
    if(Error1_last)   lcd3.print("MP*1 ACHTUNG"); 
    else          lcd3.print("MP*1 H\357he ok");
    lcd3.setCursor(-4,3);
    if(Error2_last)   lcd3.print("MP*2 ACHTUNG");
    else          lcd3.print("MP*2 H\357he ok");  
  }
  else
  {
    if(Error1_last)   lcd3.print("MP 1 ACHTUNG"); 
    else          lcd3.print("MP 1 H\357he ok");
    lcd3.setCursor(-4,3);
    if(Error2_last)   lcd3.print("MP 2 ACHTUNG");
    else          lcd3.print("MP 2 H\357he ok");
  } 
}


void HoehenTaster()
{
  if(Error1 || Error1_last)
  {
    if(!digitalRead(HoehenTasterPin))   Error2 = HIGH;
    else                                Error2 = LOW;
  }
  else   Error2 = LOW;
}

void LS()
{
  if(Error3EN)
  {
    if(digitalRead(LS_In))
    {
      Error3 = HIGH;
      analogWrite(PWM_OUT,127);
      digitalWrite(LL_OUT, HIGH);
    }
  }
}

void Ampel()
{

  if(Error3)                               //
  {
    if(ampel_case == 5 || ampel_case == 10)                         //es wird noch so lange gewartet, bis beide Ampeln durch Einspurverhalten auf Rot schalten und verbleiben dann dort
    {
      ampel_case = 9;
      Ampel_strg();
    }
    else
      {
        Ampel_strg();
      }
  }
  else if(Error2 || Error2_last || (temp>Wert_OBEN))   //Kontaktsensor hat ausgelöst oder Temp zu hoch
  {
    //Ampel einspurig
    Ampel_strg();                                                   //Ampel läuft ab aktuellem Stand in das Einspurverhalten
    previousMillis10s = currentMillis10s;
  }
  else if(!Error2 && !Error2_last && (temp<Wert_UNTEN || (temp<Wert_OBEN && tempDIR)))       //Temperatur liegt unter unterem Grenzwert
  {
    currentMillis10s = millis();
    if (currentMillis10s - previousMillis10s >= interval_wechsel) 
    {
     // previousMillis10s = currentMillis10s;
    
      if(ampel_case == 11)
      {
        ampel_case = 12;
        Ampel_strg();               //Beide Ampeln werden auf gruen geschaltet
      }
      else if (ampel_case == 7)
      {
        ampel_case = 14;
        Ampel_strg();               //Beide Ampeln werden auf gruen geschaltet
      }
      else if (ampel_case == 1)
      {
        Ampel_strg();               //Beide Ampeln werden auf gruen geschaltet
        ampel_case = 1;
      }
      else
      {
        Ampel_strg();
      }
    }
  }
  else  Ampel_strg();
}


void Ampel_strg()
{
  switch (ampel_case)                         // Fallunterscheidung für die einzelnen Ampelphasen (s. Doku)
  {                                           // bei jedem Aufruf der Funktion Ampel_strg() wird der gleihe case eingenommen bis 1 Sekunde 
    case 1:                                   // vergangen ist. Dann wird der auf den nächsten case umgeschaltet, welcher das nächste Ampel-
        DataWrite(gruen1 | gruen2);           // muster beinhaltet
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 2;
        }
        break;
    case 2:
        DataWrite(gelb1 | gruen2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 3;
        }
        break;
    case 3:
        DataWrite(rot1 | gruen2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_gruen) 
        {
          previousMillis = currentMillis;
          ampel_case = 4;
        }
        break;
    case 4:
        DataWrite(rot1 | gelb2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 5;
        }
        break;
    case 5:
        DataWrite(rot1 | rot2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 6;
        }
        break;
    case 6:
        DataWrite((rot1 | gelb1) | rot2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 7;
        }
        break;
    case 7:
        DataWrite(gruen1 | rot2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_gruen)   // Das Intervall für die Pause bei Grün ist 5 Sekunden lang
        {
          previousMillis = currentMillis;
          ampel_case = 8;
        }
        break;
    case 8:
        DataWrite(gelb1 | rot2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 9;
        }
        break;
    case 9:
        DataWrite(rot1 | rot2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 10;
        }
        break;
    case 10:
        DataWrite(rot1 | (rot2 | gelb2));
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 11;
        }
        break;
    case 11:
        DataWrite(rot1 | gruen2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_gruen) 
        {
          previousMillis = currentMillis;
          ampel_case = 4;                             // um den Kreislauf der Ampelphasen herzustellen wird nach case 11 wieder auf case 4 
        }                                             // gesprungen
        break;
    case 12:
        DataWrite((rot1 | gelb1) | gruen2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 13;
        }
        break;
    case 13:
        DataWrite(gruen1 | gruen2);
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel) 
        {
          previousMillis = currentMillis;
          ampel_case = 1;
        }
        break;
    case 14:
        DataWrite(gruen1 | (rot2 | gelb2));
        currentMillis = millis();
        if (currentMillis - previousMillis >= interval_wechsel)   
        {
          previousMillis = currentMillis;
          ampel_case = 13;
        }
        break;
    default:
        break;
  }
}

void Heizung()
{
  if(!digitalRead(Taster1) && digitalRead(Taster2))
  {
    delay(10);
    if(!digitalRead(Taster1) && digitalRead(Taster2))
    {
       digitalWrite(HeizPin, !digitalRead(HeizPin));
    }
  }
}


void ErrorOFF()
{
  Error1 = LOW;
  Error1_last = LOW;
  Error2 = LOW;
  Error2_last = LOW;
  Error3 = LOW;
  analogWrite(PWM_OUT,0);
  digitalWrite(LL_OUT, LOW);
}


void loop()
{
  Abstand_Mess();
  HoehenTaster();
  LS();
  analogOUT(Abstand);
  Ampel();
  Heizung();
  LCD_OUT();
  
}
