#include <LiquidCrystal.h>
// kompiliert 23.10.2022 mit IDE 1.8.15
// Solaranlage Leistungsmessung
// Daten LCD D4... D7 ARDUINO
// D0 , D1 ist die serielle Schnittstelle
// D2 ist Enable LCD
// D3 ist C/D von LCD
// A0 ist der Stommesswert der Solarzelle
// A1 ist Solarspannung
// D10 ist Messzyklus
// D11 ist Ausgang fuer ALarm
// D8 ist Daten Schaltungserweiterung Schieberegister
//D12 ist Takt Schaltungserweiterungt Schieberegister
// AD0 ist Stromwert
// AD1 ist Spannungswert
// AD2 ist Relais
// externe Referenz 2.048 V
// Spannungsmesseung mit Teiler /6
// 12,276 V = AD-Wert 1023
// Strommesssung mit Verstärkung 20
// 1 Ohm * 204,6 mA = AD Wert 1023
// 1023 * 1023 = 1,0463W = 1046529  
LiquidCrystal lcd(2, 3, 4, 5, 6, 7); 
long uwert;   //Spannungswert A/D -Wandler
long uanz;    // Spannungswert Anzeige
int upin = A1;
long iwert;   //Stromwert A/D Wandler 
long ianz;    // Stromwert Anzeige
int ipin = A0;
long pwert;    //Leistungswert
float leistung;
int schiebedata;
int pwm = 9;
int messzy = 10;  // NE555 loest ca alle Sekunde Messung aus
int alarm = 11;
int taktpin  = 12;
int datapin = 8;
int pwmwert;
int i;
int ledanzahl;    // Anzahl LED
boolean aktflanke;    //aktueller Zusatand NE555 Ausgang
boolean altflanke;    // vorheriger Zustand NE555 Ausgang
int abschalt= A2;
//
void setup()
{
analogReference(EXTERNAL); 
pinMode(messzy, INPUT);
pinMode(alarm, OUTPUT);
pinMode(taktpin, OUTPUT);
pinMode(datapin,OUTPUT);
pinMode(pwm,OUTPUT);
pinMode(upin,INPUT);
pinMode(ipin,INPUT);
pinMode(abschalt,OUTPUT);
alarmoff();
relab();
lcd.begin(16,4);
lcd.setCursor(0, 0);
lcd.print ("Solaranlage");
lcd.setCursor(0, 1);
lcd.print ("EGS Sommer 2023");
delay(5000);
Serial.begin(9600);
Serial.println("EGS Sommer 2023");
//zustand = false;
}

void alarmon()
{
digitalWrite(alarm,HIGH);
}

void alarmoff()
{
digitalWrite(alarm,LOW);  
} 
void relan()
{
 digitalWrite(abschalt,HIGH); 
}

void relab()
{
 digitalWrite(abschalt,LOW); 
  }
void shiftOut(int datapin,int taktpin,byte schiebedata)
{
  digitalWrite(datapin,LOW);
  digitalWrite(taktpin,LOW);
  for (i=7; i>=0; i--) 
  {
    digitalWrite(taktpin,LOW);
    if (schiebedata & (1<<i))
    {
      digitalWrite(datapin,HIGH);
    }
    else 
    { 
      digitalWrite(datapin,LOW);
    }
     digitalWrite(taktpin,HIGH);
     digitalWrite(datapin,LOW);
  }
digitalWrite(taktpin,LOW);
}

void ledanzeige()
{
switch(ledanzahl)
{
 case 210 ... 255 :
 schiebedata = 255;
 shiftOut(datapin,taktpin,schiebedata);
 break;
 
 case 180 ... 209 :
 schiebedata =127;
 shiftOut(datapin,taktpin,schiebedata);
 break;
 
 case 150 ... 179 :
 schiebedata = 63;
 shiftOut(datapin,taktpin,schiebedata);
 break;
 
 case 120 ... 149 :
 schiebedata = 31;
 shiftOut(datapin,taktpin,schiebedata);
 break;
 
 case 80 ... 119 :
 schiebedata = 15;
 shiftOut(datapin,taktpin,schiebedata);
 break;
 
 case 60 ... 79 :
 schiebedata = 7;
 shiftOut(datapin,taktpin,schiebedata);
 break;
 
 case 31 ... 59 :
 schiebedata = 3;
 shiftOut(datapin,taktpin,schiebedata);
 break;
 
 case 8 ... 30 :
 schiebedata = 1;
 shiftOut(datapin,taktpin,schiebedata);
 break;
}
}


void loop() 
{
while (digitalRead(messzy) == HIGH)
{
  
}
uwert = analogRead(upin);
iwert = analogRead(ipin);
pwert = (uwert*iwert);
if (pwert > 790000 || uwert > 1022) 
{
alarmon();
relan();
//Serial.println("Overload !!!");
lcd.clear();
lcd.print("  OVERLOAD  !");
shiftOut(datapin,taktpin,255);
}
else
{
alarmoff();  
uanz = uwert *6 * 2048;
uanz = uanz/1000;
ianz = iwert *1024;
ianz = ianz/10000;
leistung = uanz * ianz;
leistung = leistung /1000;
lcd.clear();
lcd.print("Sonnenleistung:"); 
lcd.setCursor(0,1);
lcd.print(leistung);
lcd.print("mW");
lcd.setCursor(0,2);
lcd.print("Spannung:");
lcd.print(uanz);
lcd.print("mV");
lcd.setCursor(0,3);
lcd.print("Strom : ");
lcd.print(ianz);
lcd.print(" mA");
pwmwert = (pwert/4096);
analogWrite(pwm, pwmwert);
ledanzahl = pwert/4096;
ledanzeige(); 
shiftOut(datapin,taktpin,schiebedata);
}
while (digitalRead(messzy) == LOW)
{
 }
alarmoff();
relab();
Serial.println ( ); 
}
