#include <LiquidCrystal.h>
//digital direkt anzeigendes Ohmmeter mit automatischer Messbereichswahl
// D8  Taster 1 Messen
// D10 Taster 2 Abgleich
// D9 Vibrationsmotor
// D4,D5,D6,D7 Datenleitungen fuer LCD
// D2  = Kommand /Daten LCD
// D3  = Enable LCD
LiquidCrystal lcd(2, 3, 4, 5, 6, 7);
int analogwert;          //Spannungsmesswert
int analogPin = A0;
float widerwert;
int ButtonPin1 = 8;
int ButtonPin2 = 10;
int Vibro = 9;
int taster1;
int taster2;
int tasterstatus1 = HIGH;
int tasterstatus2 = HIGH;
unsigned long tasterzeit1;
unsigned long tasterzeit2;
int tastergedrueckt1;
int tastergedrueckt2;
int tastergedrueckt;
int vbanzahl;
int wert;
unsigned long entprellzeit = 200;
int adr0 = 11;
int adr1 = 12;
int adr2 = 13;
int adresse;
int messbereich;
int abgleichstatus;
int messstatus;

void setup()
{
  analogReference(EXTERNAL);     //2,048V
  pinMode(adr0, OUTPUT);
  pinMode(adr1, OUTPUT);
  pinMode(adr2, OUTPUT);
  pinMode(ButtonPin1, INPUT);
  pinMode(ButtonPin2, INPUT);
  pinMode(Vibro, OUTPUT);
  lcd.begin(16,4);
  lcd.setCursor(0,0);
  lcd.print ("AUTO-Ohmmeter");
  lcd.setCursor(0,1);
  lcd.print ("EGS Sommer 2022");
  delay(3000);
  Serial.begin(9600);
  Serial.println("EGS Sommer2022");
  messbereich = 2 ;
  taster1 = digitalRead(ButtonPin1);
  if (taster1 == LOW)
  {
    Serial.println( "***** TESTLAUF *****");
    Serial.println(" Kontrolle ob LED und OptoMOS funktionieren ");
    mbeinstellung(4);
    delay(500);
    mbeinstellung(3);
    delay(500);
    mbeinstellung(2);
    delay(500);
    mbeinstellung(1);
    delay(500);
    Serial.println("Haben alle LED geleuchtet ?");
    delay(1000);
    Serial.println("Taster 1 loslassen");
    delay(1000);
    messbereich = 2;
  }
  else
  {}
}
void messung()
{
  analogwert = analogRead(analogPin);
  if (analogwert > 1003)
  {
    if (messbereich < 4 )
    {
      messbereich = messbereich + 1;         
    }  
  }  

  if (analogwert < 21)
  {
    if (messbereich > 1)
    {
      messbereich = messbereich - 1;
    }
  } 
}

// Einstellung des Messbereichs
void mbeinstellung(int messbereich)
{
  switch (messbereich)
  {
    case 4:
      digitalWrite(adr0, LOW);     //Messung mit 1 MOHM Referenz
      digitalWrite(adr1, LOW);
      digitalWrite(adr2, LOW);
      break;
    case 3:
      digitalWrite(adr0, HIGH);     //Messung mit 100 kOHM Referenz
      digitalWrite(adr1, LOW);
      digitalWrite(adr2, LOW);
      break;
    case 2:
      digitalWrite(adr0, LOW);      //Messung mit 10 KOHM Referenz
      digitalWrite(adr1, HIGH);
      digitalWrite(adr2, LOW);
      break;
    case 1:
      digitalWrite(adr0, HIGH);      // Messung mit 1 KOHM Referenz
      digitalWrite(adr1, HIGH);
      digitalWrite(adr2, LOW);
      break;
  }
}
void anzeige()
{
lcd.clear();
lcd.print("Messwert :");
lcd.setCursor(12,0);
lcd.print(analogwert);  
lcd.setCursor(0,1);
lcd.print("Messbereich : ");
lcd.print(messbereich);
lcd.setCursor(0,2);
lcd.print("Widerstandswert");
  
  if (messbereich == 1 )
  {
    widerwert = analogwert * 10.00;
    lcd.setCursor(0, 3);
    lcd.print (widerwert);
    lcd.print (" Ohm");
    Serial.print(widerwert);
    Serial.println(" Ohm");
    delay(2000);
    for (int vbanzahl = 1; vbanzahl <= 1; vbanzahl++)
    {
      digitalWrite(Vibro, HIGH);
      delay(500);
      digitalWrite(Vibro, LOW);
      delay(500);
    }
  }

  if (messbereich == 2 )
  {
    widerwert = analogwert / 10.00;
    lcd.setCursor(0, 3);
    lcd.print (widerwert);
    lcd.print (" kOhm");
    Serial.print(widerwert);
    Serial.println(" kOhm");
    delay(2000);
    for (int vbanzahl = 1; vbanzahl <= 2; vbanzahl++)
    {
      digitalWrite(Vibro, HIGH);
      delay(500);
      digitalWrite(Vibro, LOW);
      delay(500);
    }
  }

  if (messbereich == 3)
  {
    widerwert = analogwert / 1.00;
    lcd.setCursor(0, 3);
    lcd.print (widerwert);
    lcd.print(" kOhm");
    Serial.print(widerwert);
    Serial.println(" kOhm");
    delay(2000);
    for (int vbanzahl = 1; vbanzahl <= 3; vbanzahl++)
    {
      digitalWrite(Vibro, HIGH);
      delay(500);
      digitalWrite(Vibro, LOW);
      delay(500);
    }
  }
  if (messbereich == 4 )
  {
    widerwert = analogwert/100.00;
    lcd.setCursor(0, 3);
    lcd.print (widerwert);
    lcd.print(" MOhm");
    Serial.print(widerwert);
    Serial.println(" MOhm");
    delay(2000);
    for (int vbanzahl = 1; vbanzahl <= 4; vbanzahl++)
    {
      digitalWrite(Vibro, HIGH);
      delay(500);
      digitalWrite(Vibro, LOW);
      delay(500);
    }
  }
}

void abgleichmodus()
{
  tasterstatus1 = digitalRead(ButtonPin1);   //Taster 1 lesen
  tasterstatus2 = digitalRead(ButtonPin2);   //Taster 2 lesen
  delay(entprellzeit); 
  if((tasterstatus2 == LOW)&& (digitalRead(ButtonPin2)== LOW))  
  {
  tastergedrueckt1 = true;
  lcd.clear();
  lcd.print("Abgleichmodus");
  lcd.setCursor(0,2);
  lcd.print("    Beenden");
  lcd.setCursor(0,3);
  lcd.print("  Taste 2");
  }
  while (tasterstatus2 == LOW)
  {
  tasterstatus2 = digitalRead(ButtonPin2);   //Taster 2 lesen
  delay(entprellzeit);
  }
  while(tasterstatus2 == HIGH)
  {
  // bei zweitem Druck verlassen
  tasterstatus2 = digitalRead(ButtonPin2);
  } 
}

void loop()
{
lcd.clear(); 
lcd.print("Messung starten");
lcd.setCursor(0,1);
lcd.print("    Taste 1");
lcd.setCursor(0,2);
lcd.print("    Abgleich");
lcd.setCursor(0,3);
lcd.print("    Taste 2"); 
delay(1000);
tastergedrueckt = 0;
tasterstatus1 = digitalRead(ButtonPin1);
tasterstatus2 = digitalRead(ButtonPin2);
if(tasterstatus1 == LOW)
{
tastergedrueckt = tastergedrueckt + 1; 
}
else 
{
tastergedrueckt = tastergedrueckt;
}

if(tasterstatus2 ==LOW)
{
tastergedrueckt = tastergedrueckt + 2;
}
else
{
tastergedrueckt = tastergedrueckt;
}
switch(tastergedrueckt)
{
case 1: 
{
  delay(entprellzeit);
  if(digitalRead(ButtonPin1 == LOW) && (tastergedrueckt==1))
messung();                  //nach vierter Messung ist garantiert
//Serial.println(analogwert);
delay(20);
mbeinstellung(messbereich);
messung();                // der richtige Messbereich gefunden
mbeinstellung(messbereich);
//Serial.println(analogwert);
delay(20);
messung();
mbeinstellung(messbereich);
//Serial.println(analogwert);
delay(20);
messung();
mbeinstellung(messbereich);
delay(20);
messung();
messung();
lcd.clear();
lcd.setCursor(0,2);
lcd.print("Widerstand:");
anzeige();
delay(1000);
break;
}
case 2:
{
  delay(entprellzeit);
  if(digitalRead(ButtonPin2 == LOW) && (tastergedrueckt==2))
mbeinstellung(1);         //feste Vorgabe Messbereich 
abgleichmodus();
break;  
}
default:
{
tastergedrueckt = 0;
break;
}
}
}
