#include <LiquidCrystal.h>
#include <SPI.h>
//Version 15_11_2019
//Steuerung eines Class D-Demonstrationsverstärkers
// D11 Daten fuer SPI Bus zum MCP 4151
// D0 /CS für SPI Bus zum MCP 4151
// D13 Takt fuer SPI Bus zum MCP 4151 
// D8  Taster
// D9 Taster
// D10 Taster
// D4,D5,D6,D7 Datenleitungen fuer LCD
// D2  = Kommand /Daten LCD
// D3  = Enable LCD
LiquidCrystal lcd(2,3,4,5,6,7); 
int Leistung = A0;
int Lautstaerke;
int chip =0 ;             //Chipselect MCP4151 ist D0
int Ableistung;
int ButtonPin1 = 10;  
int ButtonPin2 = 9;
int ButtonPin3 = 8;
int ButtonState1 = 1;
int ButtonState2 = 1;
int ButtonState3 = 1;
int Ausgangsspannung;
float Ausgangsleistung;


void setup() 
{
Serial.begin(9600);
Serial.println("Pruefung EGS Sommer 2021");
Serial.end();
analogReference(INTERNAL);
pinMode(ButtonPin1,INPUT);
pinMode(ButtonPin2,INPUT);
pinMode(ButtonPin3,INPUT);
pinMode(chip,OUTPUT);
digitalWrite(chip,HIGH);
SPI.begin();   // Start SPI-Bus
SPI.setClockDivider(SPI_CLOCK_DIV128);
Lautstaerke = 0x80;
digitalWrite(chip,LOW);
SPI.transfer(0);
SPI.transfer(Lautstaerke);
digitalWrite(chip,HIGH);
lcd.begin(16,4);
lcd.print ("ClassD-Amplifier");
lcd.setCursor(0,2);
lcd.print ("EGS Jahr S 2021");
delay(3000);
}

// Unterprogramm zur Auswertungn der Tasten
// Achtung Schaltplan geaendert  Richtung laut / leiser
void tastenlesen()
{
  ButtonState1 = digitalRead(ButtonPin1);   // Taster 1 lesen
  ButtonState2 = digitalRead(ButtonPin2);   // Taster 2 lesen
  ButtonState3 = digitalRead(ButtonPin3);   // Taster 3 lesen
  {
    if (ButtonState1 == LOW)                //Taste 1 ist gedrueckt
    {
      lcd.clear();
      lcd.setCursor(0,0);
      lcd.print("lauter");
      if (Lautstaerke < 0x0FF)
      Lautstaerke = (Lautstaerke + 1);
      lcd.setCursor(0,1);
      lcd.print("Lautstaerke:");
      //lcd.print (255 - Lautstaerke); 
      lcd.print(Lautstaerke);      
       digitalWrite(chip,LOW);
      SPI.transfer(0);
      SPI.transfer(Lautstaerke);
      digitalWrite(chip,HIGH);
      delay(50);
    }
    if (ButtonState2 == LOW)               //Taste 2 ist gedrueckt
    {
      lcd.clear();
      lcd.setCursor(0,0);
      lcd.print("   Messung ");
      lcd.setCursor(0,1);
      lcd.print("Ausgangsleistung");
      leistungsmessung();
      delay(500);
    }
    if (ButtonState3 == LOW)                 // Taste 3 ist gedrueckt 
    {
      lcd.clear();
      lcd.setCursor(0,0);
      lcd.print("leiser");
      if (Lautstaerke >= 0x01)
      Lautstaerke = (Lautstaerke -1);
      lcd.setCursor(0,1);
      lcd.print("Lautstaerke:");
      //lcd.print (256 - Lautstaerke);
      lcd.print(Lautstaerke);
      digitalWrite(chip,LOW);
      SPI.transfer(0);
      SPI.transfer(Lautstaerke);
      digitalWrite(chip,HIGH);
      delay(50);
    }
  }
}


void leistungsmessung()
{
  Ausgangsspannung = analogRead(A0);
 Ausgangsleistung = float(Ausgangsspannung);         //nicht mehr Ganzzahl    
 
  Ausgangsleistung = Ausgangsleistung * Ausgangsleistung;

  Ausgangsleistung = Ausgangsleistung * 30 ;//genauer 2* SQR 2
  Ausgangsleistung = Ausgangsleistung/22500;
  Ausgangsleistung = (int) Ausgangsleistung;
  lcd.setCursor(0,2);
  lcd.print("Leistung:");
  lcd.setCursor(7,3);
  lcd.print (Ausgangsleistung);
  lcd.print ("mW");
  delay(500);
}

void loop() 
{
Ableistung = analogRead(Leistung);
tastenlesen();
delay(20);
}
