const int Led_Piezo = 5;
const int NorGatter = 4;
const int StartTaster = 3;
const int StopTaster = 2;
const int HochTaster = 1;
const int RunterTaster = 0;

int Spieler = 0;                  //Welcher Spieler ist an der Reihe
int Arraywert = 1;                //Wert der obersten Zeile von der ZeitenLedMatrix
int ZeitenLedMatrix[5][7] = {0};  //Darin werden die Reaktionszeiten der Spieler nur grob gespeichert
int ZeitenMatrix[5][2] = {0};     //Darin werden die Reaktionszeiten der einzelnen Spielern genau gespeichert     
int SpielerAusgabeArray[7] = {0}; //Darin ist für die Ausgabe die momentane Spielerzahl gespeichert
int AnzahlSpieler = 1;            //Wie viele Spieler spielen mit
int Zaehler = 0;                  //Zaehler für die Laufschrift
int Wortlaenge = 0;               //Arraygröße in der das auszugebende Wort drin steht
int AnzahlSpalten = 7;            //LED-Matrix
int AnzahlZeilen = 5;             //LED-Matrix
int AnzahlDurchlauf = 0;          //Haüfigkeit des Durchlaufs --> Laufschrift; X = festgelegte Anzahl der Durchläufe; 0 = ständiger Durchlauf
int Spieldurchlaeufe = 0;         //Zählt die einzelnen Spiele hoch
int SchnellsterSpieler = 10;      //Der schnellste Spieler ist zu Beginn auf den Wert 10 gesetzt, da es noch keinen schnellsten Spieler gibt
int Spaltenzaehler = 0;           //Zähl die Spalten hoch
int temp = 0;                     //Temporäre Variable für das Entprellen der Taster
int Laufgeschwindigkeit = 150;

void setup() {
  for (int i = 5; i <= 13; i++)
  {
    pinMode(i, OUTPUT);       //Pin 5-13 als OUTPUT festlegen
    digitalWrite(i, LOW);     //Pin 5-13 auf LOW setzen
  }
  for (int i = 0; i <= 4; i++)
  {
    pinMode(i, INPUT);       //Pin 0-4 als INPUT festlegen
  }
  Serial.begin(9600);
  Serial.println("EGS-Pruefung Teil 1, Herbst 2023");

  if (digitalRead(StopTaster)==LOW)
  {
    Testmodus();
  }
}

void loop()
{
  
  
  if (Spieldurchlaeufe < 1)
  { //in dem Array HalloMatrix steht das Wort "Reaktionstest"
    //Anzeigebeispiel für ein R:
    //Zeile 0   --> Arraywert 1       1 1 1
    //Zeile 1   --> Arraywert 2       2     2
    //Zeile 2   --> Arraywert 4       4 4 4 4
    //Zeile 3   --> Arraywert 8       8   8
    //Zeile 4   --> Arraywert 16      16    16
    //Die Buchstaben werden Spalte für Spalte genauer betrachtet 
    //Die erste Spalte von dem R wird betrachte und die Arraywerte (Zeilen) werden miteinander addiert 
    //Summe der einzelnen Spalten von R: erste Spalte: 31 --> zweite Spalte: 5 --> dritte Spalte: 13 --> vierte Spalte: 22 --> fünfte Spalte: 0
    //Die Summe der einzelnen Spalten wird in das 1D-Array für die Ausgabe geschrieben
    int HalloMatrix[80] = {0, 0, 0, 0, 0, 0, 0, 31, 5, 13, 22, 0, 31, 21, 21, 17, 0, 30, 5, 5, 30, 0, 31, 4, 10, 17, 0, 1, 1, 31, 1, 1, 0, 31, 0, 14, 17, 17, 14, 0, 31, 2, 4, 8, 31, 0, 23, 21, 21, 29, 0, 1, 1, 31, 1, 1, 0, 31, 21, 21, 17, 0, 23, 21, 21, 29, 0, 1, 1, 31, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
    Matrix(HalloMatrix, 80, AnzahlDurchlauf = 1, Laufgeschwindigkeit);       //HalloMatrix, die Arraygröße und AnzahlDurchlauf wird an die Funktion Matrix übergeben 
  }                                                     //AnzahlDurchlauf = 1 bedeutet, dass das Wort nur einmal angezeigt wird

  //Wort "Spieler" steht in der Spieleranzahlmatrix
  int SpieleranzahlMatrix[44] = {0, 0, 0, 0, 0, 0, 0, 23, 21, 21, 29, 0, 31, 5, 7, 0, 31, 0, 31, 21, 21, 17, 0, 31, 16, 16, 0, 31, 21, 21, 17, 0, 31, 5, 13, 22, 0, 0, 0, 0, 0, 0, 0, 0};
  Matrix(SpieleranzahlMatrix, 44, AnzahlDurchlauf = 1,Laufgeschwindigkeit); //SpieleranzahlMatrix, die Arraygröße und AnzahlDurchlauf wird an die Funktion Matrix übergeben 

  
  
  while (digitalRead(StartTaster) == HIGH) 
  {
    Spieleranzahl();                                    //In der Funktion Spieleranzahl werden die Spieler hochgezählt
  }                                                     //Ist der Taster 2 (Schaltplan S4/Ardunio Pin 3) auf LOW, dann wird die momentane Spieleranzahl bestätigt und die while-Schleife wird verlassen

                                                        //Wort "Start druecken" steht in der StartMatrix
  int StartMatrix[83] = {0, 0, 0, 0, 0, 0, 0, 23, 21, 21, 29, 0, 1, 1, 31, 1, 1, 0, 30, 5, 5, 30, 0, 31, 5, 13, 22, 0, 1, 1, 31, 1, 1, 0, 0, 0, 0, 31, 17, 17, 14, 0, 31, 5, 13, 22, 0, 15, 16, 16, 15, 0, 31, 21, 21, 17, 0, 14, 17, 17, 0, 31, 4, 10, 17, 0, 31, 21, 21, 17, 0, 31, 2, 4, 8, 31};
  Matrix(StartMatrix, 83, AnzahlDurchlauf = 1,Laufgeschwindigkeit);         //StartMatrix, die Arraygröße und AnzahlDurchlauf wird an die Funktion Matrix übergeben 

  int AllesAnMatrix[7] = {31,31,31,31,31,31,31};
  Matrix(AllesAnMatrix,7,AnzahlDurchlauf = 10,Laufgeschwindigkeit);


  Reaktionstest();                                      //Die Funktion Reaktionstest wird aufgerufen --> Dort findet der Test statt


  for (int Zeilen = 0; Zeilen < AnzahlZeilen; Zeilen++)         //Nachdem beenden des Reaktionstests werden die alten Zeiten gelöscht, die sich in den Arrays ZeitenLedMatrix und ZeitenMatrix befinden
  {
    for (int Spalten = 0; Spalten < AnzahlSpalten; Spalten++)
    {
      ZeitenLedMatrix[Zeilen][Spalten] = 0;                     //Einträge der ZeitenLedMatrix Löschen
      if (Spalten <= 2)
      {
        ZeitenMatrix[Zeilen][Spalten] = 0;                      //Einträge der ZeitenMatrix Löschen
      }
    }
  }

  //AnzahlSpieler = 1;        //AnzahlSpieler wieder auf 1 setzen
  Spieler = 0;              //Spieler wieder auf 0 stzen
  Arraywert = 1;            //Arraywert wieder auf 1 setzen
  SchnellsterSpieler = 10;  //SchnellsterSpieler wieder auf 10 setzen
  Spaltenzaehler = 0;       //Spaltenzähler auf 0 setzen
  Spieldurchlaeufe++;       //Spieldurchläufe um eins hochzählen
}   //Ende loop




//1 18, 31, 16, 0,
//2 29, 21, 21, 23
//3 17, 21, 21, 31
//4 15, 8, 8, 28,
//5 23, 21, 21, 29


//A  30, 5, 5, 30, 0,
//B
//C  14, 17, 17, 0,
//D  31, 17, 17, 14, 0,
//E  31, 21, 21, 17, 0,
//F  31, 5, 5, 1, 0,
//G  14, 17, 21, 29, 0,
//H  31, 4, 4, 31, 0,
//I  31, 0,
//J
//K  31, 4, 10, 17, 0,
//L  31, 16, 16, 0,
//M  31, 2, 4, 2, 31, 0,
//N  31, 2, 4, 8, 31, 0,
//O  14, 17, 17, 14, 0,
//P  31, 5, 7, 0,
//Q
//R  31, 5, 13, 22, 0,
//S  23, 21, 21, 29, 0,
//T  1, 1, 31, 1, 1, 0,
//U  15, 16, 16, 15, 0,
//V
//W
//X
//Y
//Z  17, 25, 21, 19, 0,


//Der Code wurde in der externen Datei "Code_Erläuterung" unter dem Kapitel "Ansteuerung_LED_Matrix" mit einem Beispiel erklärt.

//Eingabe:
// -Die folgenden drei Werte werden an die Funktion Matrix übergeben:
//      -Das Array HauptMatrix indem das übergebene Wort steht --> Die auzugebenden Zeichen sind kodiert siehe Code_Erläuterung
//      -Die Wortlaenge = Die Größe des Arrays --> Eine Zahl
//      -AnzahlDurchlauf --> AnzahlDurchlauf gibt an wie oft ein Wort als Laufschrift an der Punktmatrix angezeigt werden soll. --> Eine Zahl

//Verarbeitung:
// -Es wird anhand des Wertes von AnzahlDurchlauf in unterschiedliche Fälle aufgeteilt
// -Die unterschiedlichen Fälle haben unterschiedliche Abbruchbedingungen
// -In allen Fällen wird die Funktion AnsteuerungMatrix solange aufgerufen bis die jeweilige Abbruchbedingung eintritt 

//Ausgabe:
// -Das Wort das sich als Zahlenwerte in dem Array HauptMatrix befindet wird an der LED-Punktmatrix als Laufschrift ausgegeben. Die Laufschrift wird so oft wiederholt wie der Wert in der Variablen "AnzahlDurchlauf" beträgt.
 

void Matrix(int HauptMatrix[], int Wortlaenge, int AnzahlDurchlauf, int waitmillis)               //In der Funktion Marix werden die übergebenen Arrays anhand dem Wert der Variable "AnzahlDurchlauf" in verschiedene Fälle unterteilt
{
  switch (AnzahlDurchlauf)                                                        
  {
    case 0:                                                                       //AnzahlDurchlauf = 0 --> Laufschrift wiederholt sich unendlich oft bis digitalRead(StartTaster) auf LOW ist 
      while (digitalRead(StartTaster) == HIGH)
      {
        AnsteuerungMatrix(HauptMatrix, Wortlaenge, waitmillis);                               //HauptMatrix und die Wortlänge wird an die Funktion AnsteuerungMatrix übergeben
      }
      break;
    case 10:                                                                      //Dieser Fall ist für das hochzählen der Spieler verantwortlich --> Die angezeigte Zahl wird unendlich oft angezeigt bis einer der Eingänge 0,1,3 auf Low ist
      while (digitalRead(RunterTaster) == HIGH && digitalRead(HochTaster) == HIGH && digitalRead(StartTaster) == HIGH )
      {
        AnsteuerungMatrix(HauptMatrix, Wortlaenge, waitmillis);                               //HauptMatrix und die Wortlänge wird an die Funktion AnsteuerungMatrix übergeben
      }
      break;
    default:                                                                      //AnzahlDurchlauf = x --> Das Wort wird x mal angezeigt, egal ob ein Taster gedrückt wird 
      for (int i = 0; i < AnzahlDurchlauf * (Wortlaenge - AnzahlSpalten); i++)
      {
        AnsteuerungMatrix(HauptMatrix, Wortlaenge,waitmillis);                               //HauptMatrix und die Wortlänge wird an die Funktion AnsteuerungMatrix übergeben
      };
      break;
  }
}


void AnsteuerungMatrix(int HauptMatrix[], int Wortlaenge, int waitmillis)           //AnsteuerungMatrix ist für das Multiplexen verantwortlich --> Text wird angezeigt 
{
  long t0 = millis();                                               //Startzeit der Anzeigedauer
  long t1;                                                          //Endzeit der Anzeigedauer
                                 
  const byte ZeilenPins[AnzahlZeilen] = {6, 7, 8, 9, 10};           //In dem Array stehen die Zeilenpins
  const byte DecoderPins[3] = {11, 12, 13};                         //In dem Array stehen die Pins zur Ansteuerung des IC 74HCT138 

  if (Zaehler > Wortlaenge - AnzahlSpalten )                        //Wenn das Ende der Laufschrift nicht erreicht is
  {
    Zaehler = 0;                                                    //Zaehler wieder auf 0 setzen --> Durchlauf beginnt von vorne
  }
  do
  {
    for (int Spalte = 0; Spalte < AnzahlSpalten; Spalte++)          //Die for-Schleife geht durch die einzelnen Spalten der Matrix durch
    {
      for (int Bit = 0; Bit < 3; Bit++)
      {
        digitalWrite(DecoderPins[Bit], bitRead(7-Spalte, Bit));       // Dekoder (Spalte) ansteuern
      }
      for (int Zeile = 0; Zeile < AnzahlZeilen; Zeile++)            // Kathoden ansteuern, Zeilen einschalten
      {
        if (SchnellsterSpieler == Zeile)                            
        {
        }
        else
        {
          digitalWrite(ZeilenPins[Zeile], bitRead(HauptMatrix[Spalte + Zaehler], Zeile));   //Schriftzug wird um den Wert des Zählers verschoben --> Verschiebung der Laufschrift
        }
      }
      delay(2);                                                                 //Anzeigedauer
      for (int Zeile = 0; Zeile < AnzahlZeilen; Zeile++)                                    //Alle Zeilen wieder ausschalten
      {
        digitalWrite(ZeilenPins[Zeile], LOW);
      }
    }
    t1 = millis();                                                  //Endzeit
  } while (t1 - t0 < waitmillis);                     //Solange die Differenz von End- und Startzeit klein ist als die Durchlaufgeschwindigkeit, wandert die Laufschrift nicht


  Zaehler++;                                                      //Zaehler hochzählen
}

//Eingabe:
//    -Betätigung des Start-Tasters
//    -Betätigung des Stop-Tasters hat erst eine Auswirkung wenn die LED eingschalten wurde
//    -Ausgang der Zufallszeiterzeugung

//Verarbeitung:
//    -Nachdem betätigen der Start-Taste wird die LED nach einer zufälligen Zeit (mit Hardware erzeugt) eingeschalten und die Zeit gestoppt. 
//    -Nachdem betätigen der Stop-Taste wird die Reaktionszeit ausgewertet und in einem 2D-Array gespeichert
//    -Das 2D-Array wird in ein 1D-Array umgewandelt
//        Die Umwandlung des Arrays wird in dem externen Dokument "Code_Erläuterung" in dem Kapitel "Reaktionstest"  genauer Erläutert.

//Ausgabe:
//    -Das 1D-Array (HauptMatrix[7]) das die Reaktionszeiten beeinhaltet wird an das Unterprogramm "Ansteuerung_LED_Matrix" übergeben


void Reaktionstest()                            //In dieser Funktion wird die Reaktionszeit des Spielers gemessen
{
  
  while (Spieler < AnzahlSpieler)
  {
    long ZeitStart = 0;           //Start der Reaktionszeit
    long Reaktionszeit = 0;       //Dauer der Reaktionszeit
    long AnzeigeStart = 0;        //Für die Blinkgeschwindigkeit für die Reihe des schnellsten Spielers verantwortlich     
    long AnzeigeIntervall = 0;    //Für die Blinkgeschwindigkeit für die Reihe des schnellsten Spielers verantwortlich 

    if (Spieler < AnzahlSpieler)                  //Haben alle Spieler schon gespielt?
    {
      while (ZeitStart < 1)                       //Wenn ZeitStart größer gleich 1 ist wird die while-Schleife verlassen
      {
        if (digitalRead(StartTaster) == LOW)                //Abfrage Start-Taster
        {
          while (ZeitStart < 1)                   //Wenn ZeitStart größer gleich 1 ist wird die while-Schleife verlassen
          {
            if (digitalRead(NorGatter) == HIGH)           //Abfrage von dem Ausgang des Nor-Gatters
            {
              delay(2000);                        //Das Delay ist dafür verantwortlich, dass wenn das Nor-Gatter zum Zeitpunkt des betätigen des Start-Tasters auf High ist, die LED nicht direkt eingeschalten wird
              digitalWrite(Led_Piezo, HIGH);              //LED einschalten --> Signal zum drücken der Stopptaste
              ZeitStart = millis();               //Beginn der Reaktionszeitmessung
            }
          } 
        }
      } 
      while (Reaktionszeit == 0)                  //Solange die Reaktionszeit = 0 ist, wird die while-Schleife nicht verlassen
      {
        if (digitalRead(StopTaster) == LOW)                //Abfrage Stop-Taster
        {
          digitalWrite(Led_Piezo, LOW);                   //LED wieder ausschalten
          Reaktionszeit = millis() - ZeitStart;   //Reaktionszeit stoppen und berechnen
          Serial.print("Spieler");
          Serial.print(Spieler+1);
          Serial.print(": ");
          Serial.print(Reaktionszeit);
          Serial.print("ms");
          Serial.println();
        }
      } 

      if (Reaktionszeit < 100)                    //Überprüfen auf möglichen Frühstart --> Ist die Reaktionszeit kleiner als 100ms wird der Test als Frühstart gewertet
      {
        Reaktionszeit = -1;                       //Bei einem Frühstart wird die Reaktionszeit auf -1 gesetzt
                                                  //In dem Array FruehstartMatrix befindet sich das Wort "Fruehstart" 
        int FruehstartMatrix[] = {0, 0, 0, 0, 0, 0, 0, 31, 5, 5, 1, 0, 31, 5, 13, 22, 0, 15, 16, 16, 15, 0, 31, 21, 21, 17, 0, 31, 4, 4, 31, 0, 23, 21, 21, 29, 0, 1, 1, 31, 1, 1, 0, 30, 5, 5, 30, 0, 31, 5, 13, 22, 0, 1, 1, 31, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0};
        Wortlaenge = sizeof(FruehstartMatrix) / sizeof(FruehstartMatrix[0]);   //Länge des Arrays wird berechnet --> Die größe des Arrays wird durch die größe des ersten Elementes im Array geteilt 
        Matrix(FruehstartMatrix, Wortlaenge, AnzahlDurchlauf = 1, Laufgeschwindigkeit);             //FruehstartMatrix wird an die Funktion Matrix zur Ausgabe des Wortes übergeben
      }

      ZeitenMatrix[Spieler][0] = Spieler;           //In der ZeitenMatrix stehen in der ersten Spalte die Spieler--> erste Reihe, erster Spieler --> zweite Reihe, zweiter Spieler
      ZeitenMatrix[Spieler][1] = Reaktionszeit;     //Die Reaktionszeit des dazugehörigen Spielers wird in der zweiten Spalte der jeweiligen Reihe gespeichert

      //Damit die Reaktionszeiten an der Punktmatrix ausgegeben werden können, muss dafür bestimmt werden, welche LEDs bei welcher Reaktionszeit leuchten sollen
      //In der ersten Reihe wird die Reaktionszeit des ersten Spielers dargestellt. Umso mehr Spalten leuchten, umso schlechter ist die Reaktionszeit  
        // 100ms <= 0 LED  leuchtet wenn 100ms erreicht sind oder überschritten werden
        // 130ms <= 1 LED
        // 160ms <= 2 LED 
        // 190ms <= 3 LED 
        // 220ms <= 4 LED 
        // 250ms <= 5 LED
        // 280ms <= 6 LED leuchtet wenn 400ms überschritten werden
      
      int Dauer = 100;                                            //wird dieser Wert unterschritten leuchtet keine LED --> nicht möglich, da es als Frühstart gewertet wird
      for (int Spalte = 0; Spalte < AnzahlSpalten; Spalte++)      //Zur Bestimmung welche LED leuchten soll, wurde das ZeitenLedMatrix Array erstellt, indem die zuleuchteten LEDs bestimmt werden
      {
        if (Dauer <= Reaktionszeit)                               //Solange die Dauer kleiner gleich die Reaktionszeit ist, ist die Abfrage wahr und der Arraywert der dazugehörigen Reihe wird in die momentane Spalte eingetragen
        {
          ZeitenLedMatrix[Spieler][Spalte] = Arraywert;           //Reaktionszeit anhand vom Arraywert in ZeitenLedMatrix eintragen --> ungenaue Werte anzahl LEDs
        }
        //Arraywert der ersten Reihe = 1
        //Arraywert der zweiten Reihe = 2 
        //Arraywert der dritten Reihe = 4
        //Arraywert der vierten Reihe = 8
        //Arraywert der fünften Reihe = 16   
        

        Dauer = Dauer + 30;                 //Die Dauer wird um 50ms erhöhen
      }
      Spieler++;                            //nächster Spieler
      Arraywert = Arraywert * 2;            //Arraywert verdoppeln, da es in die nächste Reihe geht 1 --> 2 --> 4 --> 8 --> 16
    }

    int HauptMatrix[AnzahlSpalten] = {0};                     //Die ZeitenLedMatrix ist ein 2D-Array. Für die ausgabe der reaktionszeit wird allerdings ein 1D-Array benötigt
    for (int Spalte = 0; Spalte < AnzahlSpalten; Spalte++)    //ZeitenLedMatrix in HauptMatrix speichern --> 2D Array in 1D Array umwandeln
    {
      for (int Zeile = 0; Zeile < AnzahlZeilen; Zeile++)
      {
        HauptMatrix[Spalte] = HauptMatrix[Spalte] + ZeitenLedMatrix[Zeile][Spalte];  //Die Werte die in der selben Spalte von der ZeitenLedMatrix stehen werden miteinander addiert und in der HauptMatrix gespeichert
        Wortlaenge = sizeof(HauptMatrix) / sizeof(HauptMatrix[0]);                   //Länge des Arrays wird berechnet
      }
    }
    if (Spieler < AnzahlSpieler)                             //Solange noch nicht alle Spieler gespielt haben, ist die Abfrage wahr
    {
      while (digitalRead(StartTaster) == HIGH)
      {
        AnsteuerungMatrix(HauptMatrix, Wortlaenge,75);          //Die Reaktionszeiten der Spieler wird nach jedem Durchlauf ausgegeben
      }
    }

    if (AnzahlSpieler == Spieler)                                                   //Wenn alle Spieler gespielt haben soll die Reihe des schnellsten Spielers blinken                          
    {                                                                               //Zum ermitteln des schnellsten Spielers wird der Bubblesort-Algorithmus verwendet
                                                                                    //Das 2D-Array ZeitenMatrix wird so sortiert, dass der schnellste Spieler in der obersten Reihe und der langsamste Spieler in der untersten Reihe steht
      int tmp1;                                                                     //temporäre Variable
      for ( int i = 0; i < 5; i++)                                                  //Bubblesort zum sortieren der Reaktionszeiten
      {
        for (int Spieler = 0; Spieler < 5 - 1; Spieler++)
        {
          if (ZeitenMatrix[Spieler][1] > ZeitenMatrix[Spieler + 1][1])              //Vergleicht die Zeiten im Array
          {
            for (int Spalte = 0; Spalte < 2; Spalte++)
            {
              tmp1 = ZeitenMatrix[Spieler][Spalte];                                 //Einträge tauschen ihre Stellen im Array, wenn die Reaktionszeit in der unteren Reihe kleiner ist als die der darüberliegenden
              ZeitenMatrix[Spieler][Spalte] = ZeitenMatrix[Spieler + 1][Spalte];
              ZeitenMatrix[Spieler + 1][Spalte] = tmp1;
            }
          }
        }
      }
      for (int i = 0; i < AnzahlZeilen; i++)                                       //Das Problem an dem sortieren der Reaktionszeiten ist, 
                                                                                   //dass bei einer kleineren Spieleranzahl als 5 in den obersten Reihen eine Reaktionszeit von 0 eingetragen 
                                                                                   //oder ein Frühstart vorliegt, welcher mit der Reaktionszeit von -1 gewertet wird 
      {
        if (ZeitenMatrix[Spaltenzaehler][0] == 0 && ZeitenMatrix[Spaltenzaehler][1] == 0 || ZeitenMatrix[Spaltenzaehler][1] == -1)  //Überprüfen ob das Array Einträge hat oder ein Frühstart vorliegt
        {
          Spaltenzaehler++;                                                                 //Beträgt die Reaktionszeit in der obersten Reihe -1 oder 0, dann soll in der nächsten Spalte überprüft werden, ob eine gültige reaktionszeit vorliegt
        } else {
          SchnellsterSpieler = ZeitenMatrix[Spaltenzaehler][0];                             //Gibt den schnellsten Spieler an
        }
      }

      while (digitalRead(StartTaster) == HIGH)                                                        //Die Zeile des schnellsten Spielers blinkt, solange digitalRead(StartTaster) == HIGH ist 
      {                                                                                     //dafür wird die Zeile in gleichmäßigen Abständen an und aus geschalten
        switch (SchnellsterSpieler)                                                         
        {
          case 10:                                                                          //Weil der schnellste Spieler 10 beträgt, sind alle Reihen eingeschalten, da es maximal nur 5 Reihen und Spieler gibt
            while (AnzeigeIntervall - AnzeigeStart < 1000 && digitalRead(StartTaster) == HIGH)        //Solange die Differenz von AnzeigeIntervall und Anzeigestart kleiner als 1000ms ist und Pin 2 auf High ist, wird die while-Schleife ausgeführt
            {
              AnsteuerungMatrix(HauptMatrix, Wortlaenge,75);                                   //Die HauptMatrix in der die Information der zu leuchteten LEDs steht wird an die Funktion AnsteuerungMatrix übergeben
              AnzeigeIntervall = millis();                                                  //Momentane Zeit wird in anzeigeIntervall gespeichert
            }
            AnzeigeStart = 0;                                                               //Zeit wieder auf 0 Setzen
            AnzeigeIntervall = 0;                                                           //Zeit wieder auf 0 Setzen
            SchnellsterSpieler = ZeitenMatrix[Spaltenzaehler][0];                           //Beim verlassen der while-Schleife wird der schnellste Spieler auf ZeitenMatrix[Spaltenzaehler][0] gesetzt
            break;
          default:                                                                          //Schnellste Zeile wird ausgeschalten
            AnzeigeStart = millis();                                                        //Momentane Teit wird in der Variablen AnzeigeStart gespeichert
            while (AnzeigeIntervall - AnzeigeStart < 500 && digitalRead(StartTaster) == HIGH)         //Solange die Differenz von AnzeigeIntervall und Anzeigestart kleiner als 500ms ist und Pin 2 auf High ist, wird die while-Schleife ausgeführt
            {
              AnsteuerungMatrix(HauptMatrix, Wortlaenge,75);                                   //Die HauptMatrix in der die Information der zu leuchteten LEDs steht wird an die Funktion AnsteuerungMatrix übergeben
              AnzeigeIntervall = millis();                                                  //Momentane Zeit wird in anzeigeIntervall gespeichert
            }
            SchnellsterSpieler = 10;                                                        //Beim verlassen der while-Schleife wird der schnellste Spieler auf 10 gesetzt
            break;
        }
      }
    }
    for (int Spalte = 0; Spalte < AnzahlSpalten; Spalte++)                                  //Einträge Hauptmatrix wieder auf 0 setzen
    {
      HauptMatrix[Spalte] = 0;
    }
  } 
}

//Eingabe:
//    -Betätigen des Tasters S2 (Taster 0 und Taster 1 beim Probeaufbau) zum hoch- oder runterzählen der Spieleranzahl

//Verarbeitung:
//    -Spieleranzahl wird hoch bzw. runtergezählt (S2 nach oben oder unten betätigen)
//    -In dem SpielerArray ist in der obersten Reihe eine 1 gespeichert, in der zweiten Reihe eine 2,..... 
//         SpielerArray[5][7] =            
//         {                                              
//            0,  0,  0, 18, 31, 16, 0,   //1. Spieler   Dies wird an die Funktion Matrix übergeben um eine 1 an der LED-Matrix auszugeben     
//            0,  0, 29, 21, 21, 23, 0,   //2. Spieler     
//            0,  0, 17, 21, 21, 31, 0,   //3. Spieler     
//            0, 12, 10,  9, 31,  8, 0,   //4. Spieler     
//            0,  0, 23, 21, 21, 29, 0    //5. Spieler     
//         };                                            
//     

//Ausgabe:
//    -Das SpielerAusgabeArray (Array indem sich die momentane Spieleranzahl befindet) wird an die Funktion Matrix übergeben.


void Spieleranzahl()                  //In der Funktion wird die Spieleranzahl festgelegt
{
  
  int SpielerArray[5][7] =            //Zeilen sind Spieler; Spieler eins --> 1 Zeile, Spieler 2 --> 2 Zeile,...
  {
    0,  0,  0, 18, 31, 16, 0,         //1 Spieler
    0,  0, 29, 21, 21, 23, 0,         //2 Spieler
    0,  0, 17, 21, 21, 31, 0,         //3 Spieler
    0, 12, 10,  9, 31,  8, 0,         //4 Spieler
    0,  0, 23, 21, 21, 29, 0          //5 Spieler
  };

  for (int Spalte = 0; Spalte < 7; Spalte++)
  {
    SpielerAusgabeArray[Spalte] = SpielerArray[AnzahlSpieler - 1][Spalte];     //Einträge 2D SpielerArray in 1D SpielerAusgabeArray speichern, weil ein 1D-Array für die Ausgabe benötigt wird
  }
  Wortlaenge = sizeof(SpielerAusgabeArray) / sizeof(SpielerAusgabeArray[0]);   //Länge des Arrays
  Matrix(SpielerAusgabeArray, Wortlaenge, AnzahlDurchlauf = 10,75);               //SpielerAusgabeArray wird an die Funktion Matrix übergeben



  if (!digitalRead(HochTaster)) {                 //Spieleranzahl hochzählen
    temp = !temp;
    AnzahlSpieler++;
    if (AnzahlSpieler > AnzahlZeilen)   //Spieleranzahl kann max. so groß sein als Zeilenanzahl
    {
      AnzahlSpieler = AnzahlZeilen;     //Es kann nicht höher als AnzahlSpieler gezählt werden
    }
    delay(200);
    while (!digitalRead(HochTaster));
  }

  if (!digitalRead(RunterTaster)) {                //Spieleranzahl runterzählen
    temp = !temp;
    AnzahlSpieler--;
    if (AnzahlSpieler < 1)              //Spieleranzahl kann nicht kleiner als 1 werden
    {
      AnzahlSpieler = 1;     
    }
    delay(200);
    while (!digitalRead(RunterTaster));
  }
}


void Testmodus()
{
  Serial.print("Testmodus");
  Serial.println();
  int i=0;
  int TestMatrix[14] =  {10,21,10,21,10,21,10,21,10,21,10,21,10,21};
  
  while (digitalRead(StopTaster) == LOW){}
  
  while (digitalRead(StartTaster)==HIGH)
  {
    Matrix(TestMatrix,14,1,300);
    while (digitalRead(StopTaster)==LOW)
    {   
      digitalWrite(Led_Piezo, HIGH);              //LED einschalten --> Signal zum drücken der Stopptaste
    }  
    digitalWrite(Led_Piezo,LOW);
  }
}
