#include <Wire.h>

const int Kathoden[7] = {8,9,10,11,12,13};
const int Multiplex[3] = {5,6,7};
const int DcfPin=2; // Eingang für DCF-Empfänger

const int NormalModus=-1;
const int StundenModus=0;
const int MinutenModus=1;
const int SekundenModus=2;
const int SetzModus=3;

const int SchnellStellCount=10;
const int LangsamStellCount=25;

const int DS1307Adr=0x68;
const int SekAdr=0;
const int MinAdr=1;
const int StdAdr=2;
const int CtrAdr=7;

const int MaxTastenCount=2;
const int MaxMessZyklus=50;
const int BlinkHelligkeit=200;
const int Anzeigedauer=4;
const int MaxBlinkCount=1000;
const int MaxModusCount=1000;

int AltTaste, NeuTaste;
int ModusCount;
int StellCount;
int Steller;

int Stunden, Minuten, Sekunden, Temperatur;

int Modus;
boolean Gestellt;

byte DcfSpezBits, DcfMinuten, DcfStunden, DcfWtag, DcfTag, DcfMonat, DcfJahr;
boolean DcfEmpfangen;

//=============================================================================

void setup() {
  for (int i=0; i<7; i++) {
    pinMode(Kathoden[i],OUTPUT);
    digitalWrite(Kathoden[i],LOW);
  }
  for (int i=0; i<3; i++) {
    pinMode(Multiplex[i],OUTPUT);
    digitalWrite(Multiplex[i],HIGH);
  }
  pinMode(DcfPin,INPUT_PULLUP);
  attachInterrupt(0,dcfAuswertung,CHANGE);
  Serial.begin(9600);
  Serial.println(F("EGS Pruefung Teil 1, Herbst 2022"));
  Wire.begin();
  Modus=NormalModus;
  DcfEmpfangen=false;
  Gestellt=!HoleUhrzeit();
  SetzenDS1307(CtrAdr,0x11); // 4.096 kHz Ausgabe
}

//=============================================================================

void loop() {
  DcfStellen();
  MesseTemp();
  if (Gestellt) HoleUhrzeit();
  TastenAuswertung();
  ModusAusfuehrung();
  ZeigeAlles();
}

//=============================================================================

void ZeigeAlles() {
  ZeigeBereich(BcdBin(Stunden),0);
  ZeigeBereich(BcdBin(Minuten),1);
  ZeigeBereich(BcdBin(Sekunden),2);
  ZeigeBereich(Temperatur,3);
}

//=============================================================================

void ZeigeBereich(int Daten, int Position) {
  digitalWrite(Multiplex[0],bitRead(Position,0));
  digitalWrite(Multiplex[1],bitRead(Position,1));
  digitalWrite(Multiplex[2],LOW);

  boolean Blinken=millis()%MaxBlinkCount>=MaxBlinkCount/2;
  if (Modus==Position) {
    for (int i=0; i<7; i++) digitalWrite(Kathoden[i],Blinken);
    delayMicroseconds(BlinkHelligkeit);
  } 

  for (int i=0; i<7; i++) digitalWrite(Kathoden[i],bitRead(Daten,i));
  delay(Anzeigedauer);

  digitalWrite(Multiplex[2],HIGH);
  for (int i=0; i<7; i++) digitalWrite(Kathoden[i],LOW);
}

//=============================================================================

void MesseTemp() {
  static int MessZyklus=0;
  static int AltMesswert=0;
  static int NeuMesswert=546;
  int NeuTemperatur;
  MessZyklus++;
  if(MessZyklus>MaxMessZyklus) {
    MessZyklus=0;
    int NeuMesswert=analogRead(A0);
    if (abs(AltMesswert-NeuMesswert)>1) {
      AltMesswert=NeuMesswert;
      NeuTemperatur=NeuMesswert/2-273;
      Temperatur=constrain(NeuTemperatur,0,63);
    }
  }
}

//=============================================================================

void TastenAuswertung() {
  static int TastenCount;
  static int AktTaste;
  int MerkTaste=AktTaste;
  
  int U_Tasten=analogRead(A1);
  if (U_Tasten<73) AktTaste=0; 
  else if (U_Tasten<219) AktTaste=1;
  else if (U_Tasten<365) AktTaste=2;
  else if (U_Tasten<512) AktTaste=3;
  else if (U_Tasten<658) AktTaste=4;
  else if (U_Tasten<804) AktTaste=5;
  else if (U_Tasten<950) AktTaste=6;
  else AktTaste=7;

  if (MerkTaste==AktTaste) {
    if (TastenCount<MaxTastenCount) {
      TastenCount++;
    } else {
      AltTaste=NeuTaste;
      NeuTaste=AktTaste;
    }
  }
  else TastenCount=0;
  if (NeuTaste==0) { StellCount=0; Steller=0; }
}

//=============================================================================

void ModusAusfuehrung() {
  if (bitRead(NeuTaste,0)==1 && bitRead(AltTaste,0)==0) {
    Modus++;
    ModusCount=0;
  }
  switch(Modus) {
    case NormalModus:
            break;
    case StundenModus:
            Stellen(Stunden, 0, 0, 0x23);
            break;
    case MinutenModus:
            Stellen(Minuten, 1, 0, 0x59);
            break;
    case SekundenModus: 
            Stellen(Sekunden, 2, 0, 0x59);
            break;
    case SetzModus:
            if (Gestellt==false) {
              SetzenDS1307(StdAdr,Stunden);
              SetzenDS1307(MinAdr,Minuten);
              SetzenDS1307(SekAdr,Sekunden);
            }
            Gestellt=true;
            Modus=NormalModus;
            break;
    default:
            Modus=NormalModus;
  }
  if (Modus!=NormalModus) {
    ModusCount++;
    if (ModusCount>=MaxModusCount) Modus=NormalModus;
  }
}

//=============================================================================

void Stellen(int &Daten, int Position, int Min, int Max) {
  if (bitRead(NeuTaste,1)==1) { 
    ModusCount=0;
    if (StellenOk()) {
      IncBcd(Daten); 
      if (Daten>Max) Daten=Min; 
      if (Gestellt) SetzenDS1307(2-Position,Daten);
    }
  }
  if (bitRead(NeuTaste,2)==1) { 
    ModusCount=0;
    if (StellenOk()) {
      DecBcd(Daten); 
      if (Daten<Min) Daten=Max; 
      if (Gestellt) SetzenDS1307(2-Position,Daten);
    }
  }
}  

//=============================================================================

boolean StellenOk() {
  if (StellCount>0) {
    StellCount--;
    return false;
  } else {
    Steller++;
    if (Steller<5) StellCount=LangsamStellCount; else StellCount=SchnellStellCount;
    return true;
  }
}

//=============================================================================

void IncBcd(int &Daten) {
  Daten++;
  if ((Daten&0x000F)>0x0009) Daten=Daten+0x0006;
  if ((Daten&0x00F0)>0x0090) Daten=Daten+0x0060;
  if ((Daten&0x0F00)>0x0900) Daten=Daten+0x0600;
  if ((Daten&0xF000)>0x9000) Daten=Daten+0x6000;
}

//=============================================================================

void DecBcd(int &Daten) {
  Daten--;
  if ((Daten&0x000F)>0x0009) Daten=Daten-0x0006;
  if ((Daten&0x00F0)>0x0090) Daten=Daten-0x0060;
  if ((Daten&0x0F00)>0x0900) Daten=Daten-0x0600;
  if ((Daten&0xF000)>0x9000) Daten=Daten-0x6000;
}

//=============================================================================

int BinBcd(int BinWert) {
  int Korrektur=(BinWert/1000)*0x600+(BinWert/100)*0x060+(BinWert/10)*0x006;
  return BinWert+Korrektur;
}

//=============================================================================

int BcdBin(int BcdWert) {
  int Korrektur=(BcdWert/0x1000)*0x600+(BcdWert/0x100)*0x060+(BcdWert/0x10)*0x006;
  return BcdWert-Korrektur;
}

//=============================================================================

boolean HoleUhrzeit() {
  boolean UhrSteht=false;
  Wire.beginTransmission(DS1307Adr);
  Wire.write(0);
  Wire.endTransmission();
  
  Wire.requestFrom(DS1307Adr,3);
  if(Wire.available()==3)
  { 
    Sekunden=Wire.read();
    Minuten=Wire.read();
    Stunden=Wire.read();
    UhrSteht=bitRead(Sekunden,7)==1;
    if (UhrSteht) bitClear(Sekunden,7);
  }
  return UhrSteht;
}

//=============================================================================

void SetzenDS1307(int Adr, int Daten) {
  Wire.beginTransmission(DS1307Adr);
  Wire.write(Adr);
  Wire.write(Daten);
  Wire.endTransmission();
}

//=============================================================================

void DcfStellen() {
  if (DcfEmpfangen==true) {
    SetzenDS1307(SekAdr,0);
    SetzenDS1307(MinAdr,DcfMinuten);
    SetzenDS1307(StdAdr,DcfStunden);
    DcfEmpfangen=false;
    Gestellt=true;
  }
}
//=============================================================================

/* normale 0 = 100ms Impuls,  900ms Pause
 * normale 1 = 200ms Impuls,  800ms Pause 
 *  letzte 0 = 100ms Impuls, 1900ms Pause
 *  letzte 1 = 200ms Impuls, 1800ms Pause 
 *  hier werde nur die Pausenzeiten ausgewertet, da die Pausen weniger störanfällig sind
 */

void dcfAuswertung() {
  static byte DcfBitCount=0;
  static byte DcfBits;
  static byte DcfParitaet;
  static unsigned long t1;
  unsigned long t2;
  t2=t1; t1=millis(); t2=t1-t2;
  if (t2>750) { // Pause lange genug?
    Serial.print(t2); Serial.print(" ");
    if (t2>1750) { // lange Pause?
      Serial.println();
      if (t2<1850) DcfParitaet++; // letzte Paritätsbis = 1
      if ((DcfParitaet%2)==1) DcfBitCount=0; // Paritätsfehler
      if (DcfBitCount==58) DcfEmpfangen=true; 
      DcfBitCount=0;
    } else { // kurze Pause
//      Serial.print(t2); Serial.print(" ");
      DcfBitCount++;
      DcfBits=DcfBits>>1; // LSB kommt zuerst
      if (t2<850) { bitSet(DcfBits,7); DcfParitaet++; }
      
      switch (DcfBitCount) { // Bits auswerten
        case 1: break;  // Minutenkenung
        case 15: break; // 14 Bits ohne Bedeutung für die Zeit
        case 20: DcfSpezBits=(DcfBits>>3)&0x1F; // 5 Spezialbits
                 break; 
        case 21: DcfParitaet=0; // Startbit
                 break; 
        case 29: DcfMinuten=DcfBits&0x7F;   // 7+1 Bits für Minuten
                 if ((DcfParitaet%2)==1) DcfBitCount=0; 
                 break;
        case 36: DcfStunden=(DcfBits>>1)&0x3F; // 6+1 Bits für Stunden
                 if ((DcfParitaet%2)==1) DcfBitCount=0; 
                 break; 
        case 42: DcfTag=(DcfBits>>2)&0x3F;  // 7 Bits für Tag
                 break;
        case 45: DcfWtag=(DcfBits>>5)&0x07;  // 3 Bits für Wochentag 
                 break; 
        case 50: DcfMonat=(DcfBits>>3)&0x1F; // 5 Bits für Monat
                 break; 
        case 58: DcfJahr=DcfBits; // 8 Bits für Jahr
                 break; 
      } // switch (DcfBitCount) 
    } // if (t2>1750) 
  } // if (t2>750) 
} // void dcfAuswertung()

 
