const int UDIF_SCHWELLE = 80;

const int pinMP10=2;
const int pinMP11=3;

boolean okMP10, okMP11;

int uMP10_1, uMP10_2;
int uMP11_1, uMP11_2;

long tMP10_1, tMP10_2;
long tMP11_1, tMP11_2;

int Led;
int Blink;

int LedPins[7] = {4, 5, 6, 7, 8, 9, 10};
int Hysterese=100;

// Led               0      1      2     3    4     5     6     7
int Schwellen[8]={-9999, -3200, -1700, -200, 200, 1700, 3200, 9999};

// ================================================================================

void intMP10() {
  if (digitalRead(pinMP10)) { // LH-Wechsel
      tMP10_1=micros(); 
      uMP10_1=analogRead(A0);
    } else {                  // HL-Wechsel
      tMP10_2=micros()-tMP10_1; 
      uMP10_2=analogRead(A0);
      okMP10=true; 
    }
}

// ================================================================================

void intMP11() {
  if (digitalRead(pinMP11)) { // LH-Wechsel
      tMP11_1=micros(); 
      uMP11_1=analogRead(A0);
    } else {                  // HL-Wechsel
      tMP11_2=micros()-tMP11_1; 
      uMP11_2=analogRead(A0);
      okMP11=true; 
    }
}

// ================================================================================

void setzeLed(int Led) {
  Led=constrain(Led,0,6);
  if (Blink>=5 && millis()%300<150) Led=-1;
  for (int i=0; i<7; i++) {
    if (i==Led) digitalWrite(LedPins[i], HIGH); else digitalWrite(LedPins[i], LOW); 
  }
}

// ================================================================================

void setup() {
  Serial.begin(9600);
  Serial.println("EGS Abschlusspruefung Teil 1, Herbst 2021");
  pinMode(pinMP10,INPUT);
  pinMode(pinMP11,INPUT);
  for (int i=0; i<7; i++) {
    pinMode(LedPins[i], OUTPUT);
    digitalWrite(LedPins[i], LOW);
  }
  attachInterrupt(digitalPinToInterrupt(pinMP10), intMP10, CHANGE);
  attachInterrupt(digitalPinToInterrupt(pinMP11), intMP11, CHANGE);
  Led=3;
}

// ================================================================================

void loop() {
  if(okMP10 && okMP11) {
    int umin=min(min(uMP10_1,uMP10_2),min(uMP11_1,uMP11_2));
    int umax=max(max(uMP10_1,uMP10_2),max(uMP11_1,uMP11_2));
    int udif=umax-umin;
    if (udif<UDIF_SCHWELLE && Blink> 0) Blink--;
    if (udif>UDIF_SCHWELLE && Blink<10) Blink++;
//    Serial.print(uMP10_1); Serial.print('\t'); Serial.print(uMP10_2); Serial.print('\t'); Serial.print(uMP11_1); Serial.print('\t'); Serial.print(uMP11_2); Serial.print('\t');
//    Serial.print(uMP10_1); Serial.print('\t'); Serial.print(uMP10_2); Serial.print('\t'); Serial.print(uMP11_1); Serial.print('\t'); Serial.print(uMP11_2); Serial.print('\t');
//    Serial.println(udif);

    long td=tMP10_2-tMP11_2;
    if (td<Schwellen[Led  ]-Hysterese) Led--; 
    if (td>Schwellen[Led+1]+Hysterese) Led++; 
    setzeLed(Led);
    
    okMP10=false; okMP11=false;
 }
}

// ================================================================================
