const int S1_1_PIN=2;
const int S1_2_PIN=3;

const int P2_PIN=4;
const int P3_PIN=5;
const int P4_PIN=6;

const int POL_PIN=8;

const int K5_A_PIN=9;
const int K5_B_PIN=10;

const int K4_C1_PIN=11;
const int K4_C2_PIN=12;
const int K4_1D_PIN=13;

const int U_PIN=A0;
const int I_PIN=A1;

const int ZiffernCodes[10] = {
// .gfedcba-Balken
  B00111111, 
  B00000110, 
  B01011011, 
  B01001111, 
  B01100110, 
  B01101101, 
  B01111101, 
  B00000111, 
  B01111111, 
  B01101111
};

const byte P_Code=B01110011;
const byte O_Code=B00111111;
const byte L_Code=B00111000;

const byte E_Code=B01111001;
const byte r_Code=B01010000;
const byte U_Code=B00111110;
const byte I_Code=B00110000;

const byte LeerCode=B00000000;
const byte KommaCode=B10000000;

const int MultiplexZeit=5;
const int AnzeigeDauer=25;

const long MaxSpannung=1000;
const long MaxStrom=1000;
const long MaxLeistung=100000;
const long DeltaSpannung=5;
const long DeltaStrom=2;
const long DeltaLeistung=1;


//=============================================================================

byte AnzeigenInhalt[4];

long Spannung, Strom, Leistung;

int S1_Stellung;
bool Polaritaet;


//=============================================================================

void SetzeSegmente(byte Segmente) {
  digitalWrite(K4_C2_PIN, LOW);
  shiftOut(K4_1D_PIN, K4_C1_PIN, MSBFIRST, ~Segmente); 
  digitalWrite(K4_C2_PIN, HIGH);
}

//=============================================================================

void SetzeAnzeige(byte Anzeige) {
  SetzeSegmente(AnzeigenInhalt[4-Anzeige]);
  digitalWrite(K5_A_PIN,bitRead(Anzeige,0));
  digitalWrite(K5_B_PIN,bitRead(Anzeige,1));
}

//=============================================================================

void SetzeLeds(byte Led) {
  digitalWrite(P2_PIN, bitRead(Led,0));
  digitalWrite(P3_PIN, bitRead(Led,1));
  digitalWrite(P4_PIN, bitRead(Led,2));
}

//=============================================================================

void Multiplexen(int Oft) {
  while(Oft) {
    for (int i=1; i<=3; i++) {
      SetzeAnzeige(i);
      delay(MultiplexZeit);
    }
    Oft--;
  }
}

//=============================================================================

void AnzeigeBlinken() {
  return;
  AnzeigenInhalt[1]=LeerCode;
  AnzeigenInhalt[2]=LeerCode;
  AnzeigenInhalt[3]=LeerCode;
  Multiplexen(AnzeigeDauer);
}

//=============================================================================

void ZeigePOL() {
  AnzeigenInhalt[1]=P_Code;
  AnzeigenInhalt[2]=O_Code;
  AnzeigenInhalt[3]=L_Code;
  Multiplexen(AnzeigeDauer);
  AnzeigeBlinken();
}

//=============================================================================

void ZeigeErU() {
  AnzeigenInhalt[1]=E_Code;
  AnzeigenInhalt[2]=r_Code;
  AnzeigenInhalt[3]=U_Code;
  Multiplexen(AnzeigeDauer);
  AnzeigeBlinken();
}

//=============================================================================

void ZeigeErI() {
  AnzeigenInhalt[1]=E_Code;
  AnzeigenInhalt[2]=r_Code;
  AnzeigenInhalt[3]=I_Code;
  Multiplexen(AnzeigeDauer);
  AnzeigeBlinken();
}

//=============================================================================

void ZeigeZahl(int Zahl, int Komma)
{
  int Einer=Zahl%10; 
  Zahl=Zahl/10;
  int Zehner=Zahl%10; 
  Zahl=Zahl/10;
  int Hunderter=Zahl%10;
  AnzeigenInhalt[1]=ZiffernCodes[Hunderter];
  AnzeigenInhalt[2]=ZiffernCodes[Zehner];
  AnzeigenInhalt[3]=ZiffernCodes[Einer];
  if (Komma>0) AnzeigenInhalt[Komma]=AnzeigenInhalt[Komma]|KommaCode;
  Multiplexen(AnzeigeDauer);
}

//=============================================================================

void ZeigeSpannung() {
  SetzeLeds(B001);
  if (Spannung>MaxSpannung) {
    ZeigeErU();
  } else {
    ZeigeZahl(Spannung/5,2);
  }
}

//=============================================================================

void ZeigeStrom() {
  SetzeLeds(B010);
  if (Strom>=MaxStrom) {
    ZeigeErI();
  } else {
    ZeigeZahl(Strom,0);
  }
}

//=============================================================================

void ZeigeLeistung()
{
  SetzeLeds(B100);
  digitalWrite(P2_PIN,LOW);
  digitalWrite(P3_PIN,LOW);
  digitalWrite(P4_PIN,HIGH);
  bool Fehler=false;
  if (Spannung>MaxSpannung) {
    ZeigeErU();
    Fehler=true;
  }
  if (Strom>=MaxStrom) {
    ZeigeErI();
    Fehler=true;
  }
  if (Fehler==false) {
    int Komma=1;
    if (Leistung>=MaxLeistung) {
      Leistung=Leistung/10;
      Komma++;
    }
    ZeigeZahl(Leistung/100,Komma);
  }
}

//=============================================================================

void Eingabe() {
  long AktSpannung=analogRead(U_PIN);
  long AktStrom=analogRead(I_PIN);
  if (abs(AktSpannung-Spannung)>=DeltaSpannung || AktSpannung==0) Spannung=AktSpannung;
  if (abs(AktStrom-Strom)>=DeltaStrom || AktStrom==0) Strom=AktStrom;
  S1_Stellung=digitalRead(S1_1_PIN)+digitalRead(S1_2_PIN)*2;
  Polaritaet=digitalRead(POL_PIN);
}

//=============================================================================

void Verarbeitung() {
  long AktLeistung=(Spannung*Strom)/5;
  if (abs(AktLeistung-Leistung)>=DeltaLeistung || AktLeistung==0) Leistung=AktLeistung;
}

//=============================================================================

void Ausgabe() {
  if (Polaritaet==HIGH) { 
    ZeigePOL(); 
  } else {
    switch(S1_Stellung) {
      case 1: ZeigeSpannung(); break;
      case 2: ZeigeLeistung();break;
      case 3: ZeigeStrom(); break;
    }
  }
}

//=============================================================================

void setup() {
  Serial.begin(9600);
  Serial.println("EGS-Pruefung Teil 1, Fruehjahr 2023");
  
  pinMode(S1_1_PIN, INPUT);
  pinMode(S1_2_PIN, INPUT);

  pinMode(P2_PIN, OUTPUT);
  pinMode(P3_PIN, OUTPUT);
  pinMode(P4_PIN, OUTPUT);

  pinMode(POL_PIN, INPUT);

  pinMode(K5_A_PIN, OUTPUT);
  pinMode(K5_B_PIN, OUTPUT);

  pinMode(K4_C1_PIN, OUTPUT);
  pinMode(K4_C2_PIN, OUTPUT);
  pinMode(K4_1D_PIN, OUTPUT);
}

//=============================================================================

void loop() {
  Eingabe();
  Verarbeitung();
  Ausgabe();
}

//=============================================================================

