const int TastenPins[2]={2, 3};
const int DecoderPins[2]={4, 5};
const int SegmentePins[8]={6, 7, 8, 9, 10, 11, 12, 13};
const int LichtschrankenPins[3]={A0, A1, A2};
const int JumperPins[2]={A3, A4};
const int PiezoPin=A5;
//=======================================================================================
const byte a_Balken=B00000001;
const byte b_Balken=B00000010;
const byte c_Balken=B00000100;
const byte d_Balken=B00001000;
const byte e_Balken=B00010000;
const byte f_Balken=B00100000;
const byte g_Balken=B01000000;
const byte h_Balken=B10000000;

// benötigte Ziffern
const byte ZiffernCodes[10] = {
              a_Balken+b_Balken+c_Balken+d_Balken+e_Balken+f_Balken,           // 0
                       b_Balken+c_Balken,                                      // 1
              a_Balken+b_Balken+         d_Balken+e_Balken+         g_Balken,  // 2
              a_Balken+b_Balken+c_Balken+d_Balken+                  g_Balken,  // 3
                       b_Balken+c_Balken+                  f_Balken+g_Balken,  // 4
              a_Balken+         c_Balken+d_Balken+         f_Balken+g_Balken,  // 5
              a_Balken+         c_Balken+d_Balken+e_Balken+f_Balken+g_Balken,  // 6
              a_Balken+b_Balken+c_Balken                                    ,  // 7
              a_Balken+b_Balken+c_Balken+d_Balken+e_Balken+f_Balken+g_Balken,  // 8
              a_Balken+b_Balken+c_Balken+d_Balken+         f_Balken+g_Balken}; // 9

// benötigte Buchstaben
const byte F_=a_Balken+                           e_Balken+f_Balken+g_Balken;
const byte E_=a_Balken+                  d_Balken+e_Balken+f_Balken+g_Balken;
const byte H_=         b_Balken+c_Balken+         e_Balken+f_Balken+g_Balken;
const byte L_=                           d_Balken+e_Balken+f_Balken         ;
const byte Fehltext[4]={F_, E_, H_, L_};
//=======================================================================================
const int Startdauer=500;
const int Blinkdauer=200;
const int Zwischenzeitdauer=500;

byte Anzeigen[4]={0x00,0x00, 0x00, 0x00};

unsigned long Startzeit=0;
unsigned int Hundertstel, Sekunden, Minuten;
unsigned int Ablaufzeit;

int Modus=0;
byte StartMuster;
byte AltesMuster;

boolean Akt_LS1, Akt_LS2, Akt_LS3;
boolean Alt_LS1, Alt_LS2, Alt_LS3;
boolean StartTaste, ResetTaste;
byte Jumper;
word Blinker;

//=======================================================================================

void setup() {
  int i;
  for (i=0; i<8; i++) {
    pinMode(SegmentePins[i],OUTPUT);
    digitalWrite(SegmentePins[i],LOW);
  }
  for (i=0; i<2; i++) {
    pinMode(DecoderPins[i],OUTPUT);
    digitalWrite(DecoderPins[i],LOW);
  }
  for (i=0; i<3; i++)
    pinMode(LichtschrankenPins[i],INPUT);
  for (i=0; i<2; i++)
    pinMode(TastenPins[i],INPUT);
  for (i=0; i<2; i++)
    pinMode(JumperPins[i],INPUT);

  pinMode(PiezoPin,OUTPUT);

  Modus=0;
  Serial.begin(9600);
  Serial.println(F("EGS-Abschlusspruefung Teil 1,  Fruehjahr 2022"));
}

//=======================================================================================

void loop() {
  Alt_LS1=Akt_LS1; Akt_LS1=digitalRead(LichtschrankenPins[0]);
  Alt_LS2=Akt_LS2; Akt_LS2=digitalRead(LichtschrankenPins[1]);
  Alt_LS3=Akt_LS3; Akt_LS3=digitalRead(LichtschrankenPins[2]);
  StartTaste=!digitalRead(TastenPins[0]);
  ResetTaste=!digitalRead(TastenPins[1]);
  Jumper=digitalRead(JumperPins[0])+2*digitalRead(JumperPins[1]);
    
  if (ResetTaste) Modus=0;
  switch (Jumper) {
    case 0: Jumper0(); break;
    case 1: Jumper1(); break;
    case 2: Jumper2(); break;
    case 3: Jumper3(); break;
  }
  Multiplexen();
  Blinker++;
  if (Ablaufzeit>0) Ablaufzeit--;
}

//=======================================================================================

void Jumper0() {
  switch(Modus) {
    case 0: Modus00(); break; // Startvorbereitung
    case 1: Modus10(); break; // Startphase
    case 2: Modus2(); break; // Rennen
    case 3: Modus3(); break; // Zieleinlauf
    case 4: Modus4(); break; // Fehlstart
  }
}

//=======================================================================================

void Jumper1() {
  switch(Modus) {
    case 0: Modus01(); break; // Startvorbereitung
    case 1: Modus11(); break; // Startphase
    case 2: Modus2(); break; // Rennen
    case 3: Modus3(); break; // Zieleinlauf
    case 4: Modus4(); break; // Fehlstart
  }
}
//=======================================================================================

void Jumper2() {
  switch(Modus) {
    case 0: Modus02(); break; // Startvorbereitung
    case 1: Modus12(); break; // Startphase
    case 2: Modus2(); break; // Rennen
    case 3: Modus3(); break; // Zieleinlauf
    case 4: Modus4(); break; // Fehlstart
  }
}

//=======================================================================================

void Jumper3() {
  switch(Modus) {
    case 0: Modus03(); break; // Startvorbereitung
    case 1: Modus13(); break; // Startphase
    case 2: Modus2(); break; // Rennen
    case 3: Modus3(); break; // Zieleinlauf
    case 4: Modus4(); break; // Fehlstart
  }
}

//=======================================================================================

void Modus00() {
  Anzeigen[0]=0;
  Anzeigen[1]=Akt_LS1 ? a_Balken : d_Balken;
  Anzeigen[2]=Akt_LS2 ? a_Balken : d_Balken;
  Anzeigen[3]=Akt_LS3 ? a_Balken : d_Balken;
  if (Akt_LS1 && !Akt_LS2 && !Akt_LS3 && StartTaste) { 
    StartMuster=0x0F;
    Ablaufzeit=Startdauer;
    Modus=1;
  }
}

//=======================================================================================

void Modus01() {
  Anzeigen[0]=0;
  Anzeigen[1]=Akt_LS1 ? a_Balken : d_Balken;
  Anzeigen[2]=Akt_LS2 ? a_Balken : d_Balken;
  Anzeigen[3]=Akt_LS3 ? a_Balken : d_Balken;
  if (!Akt_LS1 && !Akt_LS2 && !Akt_LS3 && StartTaste) { 
    Modus=1;
  }
  if (Akt_LS1 || Akt_LS2 || Akt_LS3) {
    Ablaufzeit=Blinkdauer;
    Modus=4;
  }
}

//=======================================================================================

void Modus02() {
  Anzeigen[0]=0;
  Anzeigen[1]=Akt_LS1 ? a_Balken : d_Balken;
  Anzeigen[2]=Akt_LS2 ? a_Balken : d_Balken;
  Anzeigen[3]=Akt_LS3 ? a_Balken : d_Balken;
  if (Akt_LS1 && !Akt_LS2 && !Akt_LS3 && StartTaste) { 
    Modus=1;
  }
}

//=======================================================================================

void Modus03() {
  Anzeigen[0]=0;
  Anzeigen[1]=Akt_LS1 ? a_Balken : d_Balken;
  Anzeigen[2]=Akt_LS2 ? a_Balken : d_Balken;
  Anzeigen[3]=Akt_LS3 ? a_Balken : d_Balken;
  if (!Akt_LS1 && !Akt_LS2 && !Akt_LS3 && StartTaste) { 
    Modus=1;
  }
}

//=======================================================================================

void Modus10() {
  for (int i=0; i<4; i++)
    if (bitRead(StartMuster,i)==1) Anzeigen[i]=g_Balken; else Anzeigen[i]=0x00;
  if (Ablaufzeit==0) {
    StartMuster=StartMuster>>1;
    Ablaufzeit=Startdauer;
    if (StartMuster==0) tone(PiezoPin,1500,300); else tone(PiezoPin,800,100); 
  }
  if(!Akt_LS1) { // Fehlstart
    Ablaufzeit=Blinkdauer;
    Modus=4;
  }
  if (StartMuster==0) {
    Startzeit=millis();
    Ablaufzeit=0;    
    Modus=2;
  }
}

//=======================================================================================

void Modus11() {
  Startzeit=millis();
  Ablaufzeit=0;    
  Modus=2;
}

//=======================================================================================

void Modus12() {
  SetzeZahl(0,B0010);
  if (!Akt_LS1) {
    Startzeit=millis();
    Ablaufzeit=0;    
    Modus=2;
  }
}

//=======================================================================================

void Modus13() {
  SetzeZahl(0,B0010);
  if (Akt_LS1) {
    Startzeit=millis();
    Ablaufzeit=0;    
    Modus=2;
  }
}

//=======================================================================================

void Modus2() {
  if (Ablaufzeit==0) TeileZeit(millis()-Startzeit);
  if(Akt_LS2 && !Alt_LS2) Ablaufzeit=Zwischenzeitdauer;
  if (Akt_LS3) {
    TeileZeit(millis()-Startzeit);
    tone(PiezoPin,2000,100); 
    Modus=3;
  }
  SetzeZeit();
}

//=======================================================================================

void Modus3() {
  if (Ablaufzeit<Blinkdauer/2) {
    LoescheAnzeige();
  } else {
    SetzeZeit();
  }
  if (Ablaufzeit==0) Ablaufzeit=Blinkdauer;
}

//=======================================================================================

void Modus4() {
  if (Ablaufzeit<Blinkdauer/2) {
    LoescheAnzeige();
  } else {
    for (int i=0; i<4; i++) Anzeigen[i]=Fehltext[i];
  }
  if (Ablaufzeit==0) Ablaufzeit=Blinkdauer;
}

//=======================================================================================

void LoescheAnzeige() {
  for (int i=0; i<4; i++) Anzeigen[i]=0x00;
}

//=======================================================================================

void Multiplexen() {
  static int Position=0;
  int Graycodes[4]={0, 1, 3, 2};
  Position++; if (Position>3) Position=0;
  int Graycode=Graycodes[Position]; 
  byte NeuesMuster=Anzeigen[Graycode];
  SetzeSegmente(AltesMuster & NeuesMuster);
  digitalWrite(DecoderPins[0], bitRead(Graycode,0));
  digitalWrite(DecoderPins[1], bitRead(Graycode,1));
  SetzeSegmente(NeuesMuster);
  delayMicroseconds(2323);
}

//=======================================================================================

void TeileZeit(unsigned long t) {
  t=t/10;
  Hundertstel=t%100; t=t/100;
  Sekunden=t%60; t=t/60;
  Minuten=t;
}

//=======================================================================================

void SetzeSegmente(byte Muster) {
  for (int i=0; i<8; i++)
    digitalWrite(SegmentePins[i],bitRead(Muster,i));
  AltesMuster=Muster;
}

//=======================================================================================

void SetzeZahl(int Zahl, byte Punkte) {
  if (Zahl>9999) Zahl=9999;
  for (int i=3; i>=0; i--) {
    byte Muster=ZiffernCodes[Zahl%10];
    if (bitRead(Punkte,i)) Muster=Muster|h_Balken;
    Anzeigen[i]=Muster;
    Zahl=Zahl/10;
  }
}

//=======================================================================================

void SetzeZeit() {
  if (Minuten==0) {
    SetzeZahl(Sekunden*100+Hundertstel, B0010);
  } else {
    if (Minuten<10) {
      SetzeZahl(Minuten*1000+Sekunden*10+Hundertstel/10, B0101);
    } else {
      SetzeZahl(Minuten*100+Sekunden, B1010);
    }
  }
}

//=======================================================================================

