const byte LinksTaste=_BV(0);
const byte RechtsTaste=_BV(1);

const byte K3=_BV(0);
const byte K5=_BV(1);
const byte K7=_BV(2);
const byte K9=_BV(3);

const byte RelaisPfade[8] = {0, K3, K7, K3+K7, K9, K5+K9, K7+K9, K5+K7+K9};

const byte RelaisPins[4] = {8, 9, 10, 11};
const byte DecoderPins[3] = {5, 6, 7};
const byte TastenPins[2] = {2, 3};

byte Pfad;
byte AltTasten;
byte NeuTasten;

byte leseTasten() {
  return digitalRead(TastenPins[0])*LinksTaste+digitalRead(TastenPins[1])*RechtsTaste;
}

void setup() {
  Serial.begin(9600);
  Serial.println("Termin");
  for (int i=0; i<sizeof(RelaisPins); i++) {
    pinMode(RelaisPins[i],OUTPUT);
    digitalWrite(RelaisPins[i],LOW);
  }
  for (int i=0; i<sizeof(DecoderPins); i++) {
    pinMode(DecoderPins[i],OUTPUT);
    digitalWrite(DecoderPins[i],LOW);
  }
  for (int i=0; i<sizeof(TastenPins); i++) {
    pinMode(TastenPins[i],INPUT);
  }
  Pfad=0;
  NeuTasten=leseTasten();
}

void Eingabe() {
  AltTasten=NeuTasten;
  NeuTasten=leseTasten();
}

void Verarbeitung() {
  byte Tasten=(AltTasten^NeuTasten)&NeuTasten;
  if (Tasten&LinksTaste && Pfad>0) Pfad--;
  if (Tasten&RechtsTaste && Pfad<7) Pfad++;
}

void Ausgabe() {
  byte Relais=RelaisPfade[Pfad];
  for (int i=0; i<sizeof(RelaisPins); i++)
    digitalWrite(RelaisPins[i],bitRead(Relais,i));
  
  for (int i=0; i<sizeof(DecoderPins); i++)
    digitalWrite(DecoderPins[i],bitRead(Pfad,i));
}

void loop() {
  Eingabe();
  Verarbeitung();
  Ausgabe();  
  delay(20);
}

